'use client';

import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { tokens } from '@fluentui/react-theme';
import { useInputStyles_unstable } from '@fluentui/react-input';
export const searchBoxClassNames = {
  root: 'fui-SearchBox',
  dismiss: 'fui-SearchBox__dismiss',
  contentAfter: 'fui-SearchBox__contentAfter',
  contentBefore: 'fui-SearchBox__contentBefore',
  input: 'fui-SearchBox__input'
};
/**
 * Styles for the root slot
 */
const useRootStyles = /*#__PURE__*/__styles({
  small: {
    i8kkvl: "fjuset5",
    B2u0y6b: "f1xzfw5u",
    uwmqm3: ["fk8j09s", "fdw0yi8"],
    z189sj: ["fdw0yi8", "fk8j09s"]
  },
  medium: {
    i8kkvl: "fjuset5",
    B2u0y6b: "f1xzfw5u",
    uwmqm3: ["f1f5gg8d", "f1vdfbxk"],
    z189sj: ["f1vdfbxk", "f1f5gg8d"]
  },
  large: {
    i8kkvl: "fjuset5",
    B2u0y6b: "f1xzfw5u",
    uwmqm3: ["f1ng84yb", "f11gcy0p"],
    z189sj: ["f11gcy0p", "f1ng84yb"]
  },
  input: {
    uwmqm3: ["fk8j09s", "fdw0yi8"],
    z189sj: ["fhxju0i", "f1cnd47f"],
    Boqhc8c: "f18izjht",
    B8uat0v: "fcoa6sg"
  },
  unfocusedNoContentAfter: {
    z189sj: ["fhxju0i", "f1cnd47f"]
  }
}, {
  d: [".fjuset5{column-gap:0;}", ".f1xzfw5u{max-width:468px;}", ".fk8j09s{padding-left:var(--spacingHorizontalSNudge);}", ".fdw0yi8{padding-right:var(--spacingHorizontalSNudge);}", ".f1f5gg8d{padding-left:var(--spacingHorizontalS);}", ".f1vdfbxk{padding-right:var(--spacingHorizontalS);}", ".f1ng84yb{padding-left:var(--spacingHorizontalMNudge);}", ".f11gcy0p{padding-right:var(--spacingHorizontalMNudge);}", ".fhxju0i{padding-right:0;}", ".f1cnd47f{padding-left:0;}", ".f18izjht::-webkit-search-decoration{display:none;}", ".fcoa6sg::-webkit-search-cancel-button{display:none;}"]
});
const useInputStyles = /*#__PURE__*/__styles({
  small: {
    z189sj: ["fdw0yi8", "fk8j09s"]
  },
  medium: {
    z189sj: ["f1vdfbxk", "f1f5gg8d"]
  },
  large: {
    z189sj: ["f11gcy0p", "f1ng84yb"]
  }
}, {
  d: [".fdw0yi8{padding-right:var(--spacingHorizontalSNudge);}", ".fk8j09s{padding-left:var(--spacingHorizontalSNudge);}", ".f1vdfbxk{padding-right:var(--spacingHorizontalS);}", ".f1f5gg8d{padding-left:var(--spacingHorizontalS);}", ".f11gcy0p{padding-right:var(--spacingHorizontalMNudge);}", ".f1ng84yb{padding-left:var(--spacingHorizontalMNudge);}"]
});
const useContentAfterStyles = /*#__PURE__*/__styles({
  contentAfter: {
    uwmqm3: ["f1uw59to", "fw5db7e"],
    i8kkvl: "f1ufnopg"
  },
  rest: {
    Bqenvij: "fniina8",
    a9b677: "f3tsq5r",
    uwmqm3: ["f1cnd47f", "fhxju0i"],
    B68tc82: 0,
    Bmxbyg5: 0,
    Bpg54ce: "f1a3p1vp"
  }
}, {
  d: [".f1uw59to{padding-left:var(--spacingHorizontalM);}", ".fw5db7e{padding-right:var(--spacingHorizontalM);}", ".f1ufnopg{column-gap:var(--spacingHorizontalXS);}", ".fniina8{height:0;}", ".f3tsq5r{width:0;}", ".f1cnd47f{padding-left:0;}", ".fhxju0i{padding-right:0;}", [".f1a3p1vp{overflow:hidden;}", {
    p: -1
  }]]
});
const useDismissClassName = /*#__PURE__*/__resetStyles("r1pvzcuu", null, [".r1pvzcuu{box-sizing:border-box;color:var(--colorNeutralForeground3);display:flex;cursor:pointer;}", ".r1pvzcuu>svg{font-size:20px;}"]);
const useDismissStyles = /*#__PURE__*/__styles({
  disabled: {
    sj55zd: "f1s2aq7o"
  },
  small: {
    Duoase: "f3qv9w"
  },
  medium: {},
  large: {
    Duoase: "f16u2scb"
  }
}, {
  d: [".f1s2aq7o{color:var(--colorNeutralForegroundDisabled);}", ".f3qv9w>svg{font-size:16px;}", ".f16u2scb>svg{font-size:24px;}"]
});
/**
 * Apply styling to the SearchBox slots based on the state
 */
export const useSearchBoxStyles_unstable = state => {
  'use no memo';

  const {
    disabled,
    focused,
    size
  } = state;
  const rootStyles = useRootStyles();
  const inputStyles = useInputStyles();
  const contentAfterStyles = useContentAfterStyles();
  const dismissClassName = useDismissClassName();
  const dismissStyles = useDismissStyles();
  state.root.className = mergeClasses(searchBoxClassNames.root, rootStyles[size], !focused && rootStyles.unfocusedNoContentAfter, state.root.className);
  state.input.className = mergeClasses(searchBoxClassNames.input, rootStyles.input, !focused && inputStyles[size], state.input.className);
  if (state.dismiss) {
    state.dismiss.className = mergeClasses(searchBoxClassNames.dismiss, dismissClassName, disabled && dismissStyles.disabled, dismissStyles[size], state.dismiss.className);
  }
  if (state.contentBefore) {
    state.contentBefore.className = mergeClasses(searchBoxClassNames.contentBefore, state.contentBefore.className);
  }
  if (state.contentAfter) {
    state.contentAfter.className = mergeClasses(searchBoxClassNames.contentAfter, contentAfterStyles.contentAfter, !focused && contentAfterStyles.rest, state.contentAfter.className);
  } else if (state.dismiss) {
    state.dismiss.className = mergeClasses(state.dismiss.className, contentAfterStyles.contentAfter);
  }
  useInputStyles_unstable(state);
  return state;
};