'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    searchBoxClassNames: function() {
        return searchBoxClassNames;
    },
    useSearchBoxStyles_unstable: function() {
        return useSearchBoxStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reactinput = require("@fluentui/react-input");
const searchBoxClassNames = {
    root: 'fui-SearchBox',
    dismiss: 'fui-SearchBox__dismiss',
    contentAfter: 'fui-SearchBox__contentAfter',
    contentBefore: 'fui-SearchBox__contentBefore',
    input: 'fui-SearchBox__input'
};
/**
 * Styles for the root slot
 */ const useRootStyles = (0, _react.makeStyles)({
    small: {
        columnGap: 0,
        maxWidth: '468px',
        paddingLeft: _reacttheme.tokens.spacingHorizontalSNudge,
        paddingRight: _reacttheme.tokens.spacingHorizontalSNudge
    },
    medium: {
        columnGap: 0,
        maxWidth: '468px',
        paddingLeft: _reacttheme.tokens.spacingHorizontalS,
        paddingRight: _reacttheme.tokens.spacingHorizontalS
    },
    large: {
        columnGap: 0,
        maxWidth: '468px',
        paddingLeft: _reacttheme.tokens.spacingHorizontalMNudge,
        paddingRight: _reacttheme.tokens.spacingHorizontalMNudge
    },
    input: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalSNudge,
        paddingRight: 0,
        // removes the WebKit pseudoelement styling
        '::-webkit-search-decoration': {
            display: 'none'
        },
        '::-webkit-search-cancel-button': {
            display: 'none'
        }
    },
    unfocusedNoContentAfter: {
        paddingRight: 0
    }
});
const useInputStyles = (0, _react.makeStyles)({
    small: {
        paddingRight: _reacttheme.tokens.spacingHorizontalSNudge
    },
    medium: {
        paddingRight: _reacttheme.tokens.spacingHorizontalS
    },
    large: {
        paddingRight: _reacttheme.tokens.spacingHorizontalMNudge
    }
});
const useContentAfterStyles = (0, _react.makeStyles)({
    contentAfter: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalM,
        columnGap: _reacttheme.tokens.spacingHorizontalXS
    },
    rest: {
        height: 0,
        width: 0,
        paddingLeft: 0,
        overflow: 'hidden'
    }
});
const useDismissClassName = (0, _react.makeResetStyles)({
    boxSizing: 'border-box',
    color: _reacttheme.tokens.colorNeutralForeground3,
    display: 'flex',
    // special case styling for icons (most common case) to ensure they're centered vertically
    // size: medium (default)
    '> svg': {
        fontSize: '20px'
    },
    cursor: 'pointer'
});
const useDismissStyles = (0, _react.makeStyles)({
    disabled: {
        color: _reacttheme.tokens.colorNeutralForegroundDisabled
    },
    // Ensure resizable icons show up with the proper font size
    small: {
        '> svg': {
            fontSize: '16px'
        }
    },
    medium: {},
    large: {
        '> svg': {
            fontSize: '24px'
        }
    }
});
const useSearchBoxStyles_unstable = (state)=>{
    'use no memo';
    const { disabled, focused, size } = state;
    const rootStyles = useRootStyles();
    const inputStyles = useInputStyles();
    const contentAfterStyles = useContentAfterStyles();
    const dismissClassName = useDismissClassName();
    const dismissStyles = useDismissStyles();
    state.root.className = (0, _react.mergeClasses)(searchBoxClassNames.root, rootStyles[size], !focused && rootStyles.unfocusedNoContentAfter, state.root.className);
    state.input.className = (0, _react.mergeClasses)(searchBoxClassNames.input, rootStyles.input, !focused && inputStyles[size], state.input.className);
    if (state.dismiss) {
        state.dismiss.className = (0, _react.mergeClasses)(searchBoxClassNames.dismiss, dismissClassName, disabled && dismissStyles.disabled, dismissStyles[size], state.dismiss.className);
    }
    if (state.contentBefore) {
        state.contentBefore.className = (0, _react.mergeClasses)(searchBoxClassNames.contentBefore, state.contentBefore.className);
    }
    if (state.contentAfter) {
        state.contentAfter.className = (0, _react.mergeClasses)(searchBoxClassNames.contentAfter, contentAfterStyles.contentAfter, !focused && contentAfterStyles.rest, state.contentAfter.className);
    } else if (state.dismiss) {
        state.dismiss.className = (0, _react.mergeClasses)(state.dismiss.className, contentAfterStyles.contentAfter);
    }
    (0, _reactinput.useInputStyles_unstable)(state);
    return state;
};
