import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { InputOnChangeData } from '@fluentui/react-input';
import type { InputProps } from '@fluentui/react-input';
import type { InputSlots } from '@fluentui/react-input';
import type { InputState } from '@fluentui/react-input';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Render the final JSX of SearchBox
 */
export declare const renderSearchBox_unstable: (state: SearchBoxState) => JSXElement;

/**
 * SearchBox component - TODO: add more docs
 */
export declare const SearchBox: ForwardRefComponent<SearchBoxProps>;

/** Overloaded onChange event type, used to merge functionality of regular text entry and the dismiss button */
export declare type SearchBoxChangeEvent = React_2.ChangeEvent<HTMLInputElement> | React_2.MouseEvent<HTMLSpanElement>;

export declare const searchBoxClassNames: SlotClassNames<SearchBoxSlots>;

/**
 * SearchBox Props
 */
export declare type SearchBoxProps = Omit<ComponentProps<Partial<SearchBoxSlots>, 'input'>, 'children' | 'defaultValue' | 'onChange' | 'size' | 'type' | 'value'> & Omit<InputProps, 'onChange'> & {
    /**
     * Custom onChange callback.
     * Will be traditionally supplied with a React.ChangeEvent<HTMLInputElement> for usual character entry.
     * When the dismiss button is clicked, this will be called with an event of type React.MouseEvent<HTMLSpanElement>
     * and an empty string as the `value` property of the data parameter
     */
    onChange?: (event: SearchBoxChangeEvent, data: InputOnChangeData) => void;
};

export declare type SearchBoxSlots = InputSlots & {
    /** Last element in the input, within the input border */
    dismiss?: Slot<'span'>;
};

/**
 * State used in rendering SearchBox
 */
export declare type SearchBoxState = ComponentState<SearchBoxSlots> & InputState & Required<Pick<InputState, 'size'>> & Required<Pick<SearchBoxProps, 'disabled'>> & {
    focused: boolean;
};

/**
 * Create the state required to render SearchBox.
 *
 * The returned state can be modified with hooks such as useSearchBoxStyles_unstable,
 * before being passed to renderSearchBox_unstable.
 *
 * @param props - props from this instance of SearchBox
 * @param ref - reference to root HTMLElement of SearchBox
 */
export declare const useSearchBox_unstable: (props: SearchBoxProps, ref: React_2.Ref<HTMLInputElement>) => SearchBoxState;

/**
 * Apply styling to the SearchBox slots based on the state
 */
export declare const useSearchBoxStyles_unstable: (state: SearchBoxState) => SearchBoxState;

export { }
