'use client';
import * as React from 'react';
import { useRatingItem_unstable } from './useRatingItem';
import { renderRatingItem_unstable } from './renderRatingItem';
import { useRatingItemStyles_unstable } from './useRatingItemStyles.styles';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * RatingItem is an item that will be used to set or display a rating value.
 */ export const RatingItem = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useRatingItem_unstable(props, ref);
    useRatingItemStyles_unstable(state);
    useCustomStyleHook_unstable('useRatingItemStyles_unstable')(state);
    return renderRatingItem_unstable(state);
});
RatingItem.displayName = 'RatingItem';
