'use client';
import * as React from 'react';
import { useRatingDisplay_unstable } from './useRatingDisplay';
import { renderRatingDisplay_unstable } from './renderRatingDisplay';
import { useRatingDisplayStyles_unstable } from './useRatingDisplayStyles.styles';
import { useRatingDisplayContextValues } from './useRatingDisplayContextValues';
import { useCustomStyleHook_unstable } from '@fluentui/react-shared-contexts';
/**
 * RatingDisplay is a wrapper for one or more rating items that will be used to display a rating value
 * as well as the label for the rating.
 */ export const RatingDisplay = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const state = useRatingDisplay_unstable(props, ref);
    const contextValues = useRatingDisplayContextValues(state);
    useRatingDisplayStyles_unstable(state);
    useCustomStyleHook_unstable('useRatingDisplayStyles_unstable')(state);
    return renderRatingDisplay_unstable(state, contextValues);
});
RatingDisplay.displayName = 'RatingDisplay';
