'use client';
import { makeResetStyles, mergeClasses } from '@griffel/react';
export const ratingClassNames = {
    root: 'fui-Rating'
};
/**
 * Styles for the root slot
 */ const useRootClassName = makeResetStyles({
    display: 'flex',
    flexWrap: 'wrap'
});
/**
 * Apply styling to the Rating slots based on the state
 */ export const useRatingStyles_unstable = (state)=>{
    'use no memo';
    const rootClassName = useRootClassName();
    state.root.className = mergeClasses(ratingClassNames.root, rootClassName, state.root.className);
    return state;
};
