'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ratingItemClassNames: function() {
        return ratingItemClassNames;
    },
    useRatingItemStyles_unstable: function() {
        return useRatingItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const _reacttabster = require("@fluentui/react-tabster");
const ratingItemClassNames = {
    root: 'fui-RatingItem',
    selectedIcon: 'fui-RatingItem__selectedIcon',
    unselectedIcon: 'fui-RatingItem__unselectedIcon',
    halfValueInput: 'fui-RatingItem__halfValueInput',
    fullValueInput: 'fui-RatingItem__fullValueInput'
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        position: 'relative',
        ...(0, _reacttabster.createFocusOutlineStyle)({
            style: {},
            selector: 'focus-within'
        })
    },
    small: {
        fontSize: '12px',
        width: '12px',
        height: '12px'
    },
    medium: {
        fontSize: '16px',
        width: '16px',
        height: '16px'
    },
    large: {
        fontSize: '20px',
        width: '20px',
        height: '20px'
    },
    'extra-large': {
        fontSize: '28px',
        width: '28px',
        height: '28px'
    }
});
const useInputBaseClassName = (0, _react.makeResetStyles)({
    position: 'absolute',
    left: 0,
    top: 0,
    right: 0,
    bottom: 0,
    boxSizing: 'border-box',
    margin: 0,
    opacity: 0,
    cursor: 'pointer',
    height: '100%'
});
const useInputStyles = (0, _react.makeStyles)({
    lowerHalf: {
        right: '50%'
    },
    upperHalf: {
        left: '50%'
    }
});
const useIndicatorBaseClassName = (0, _react.makeResetStyles)({
    display: 'flex',
    overflow: 'hidden',
    color: _reacttheme.tokens.colorNeutralForeground1,
    fill: 'currentColor',
    pointerEvents: 'none',
    position: 'absolute',
    left: 0,
    right: 0,
    top: 0,
    bottom: 0
});
const useIndicatorStyles = (0, _react.makeStyles)({
    lowerHalf: {
        right: '50%',
        '& > svg': {
            flex: '0 0 auto'
        }
    },
    upperHalf: {
        left: '50%',
        marginLeft: '-50%'
    },
    brand: {
        color: _reacttheme.tokens.colorBrandForeground1
    },
    marigold: {
        color: _reacttheme.tokens.colorPaletteMarigoldBorderActive
    },
    filled: {
        color: _reacttheme.tokens.colorNeutralBackground6,
        stroke: _reacttheme.tokens.colorTransparentStroke,
        '@media (forced-colors: active)': {
            color: 'Canvas',
            stroke: 'CanvasText'
        }
    },
    brandFilled: {
        color: _reacttheme.tokens.colorBrandBackground2
    },
    marigoldFilled: {
        color: _reacttheme.tokens.colorPaletteMarigoldBackground2
    }
});
const useRatingItemStyles_unstable = (state)=>{
    'use no memo';
    const { color, size, iconFillWidth, appearance } = state;
    const styles = useStyles();
    const inputBaseClassName = useInputBaseClassName();
    const inputStyles = useInputStyles();
    const indicatorBaseClassName = useIndicatorBaseClassName();
    const indicatorStyles = useIndicatorStyles();
    state.root.className = (0, _react.mergeClasses)(ratingItemClassNames.root, styles.root, styles[size], state.root.className);
    if (state.halfValueInput) {
        state.halfValueInput.className = (0, _react.mergeClasses)(ratingItemClassNames.halfValueInput, inputBaseClassName, inputStyles.lowerHalf, state.halfValueInput.className);
    }
    if (state.fullValueInput) {
        state.fullValueInput.className = (0, _react.mergeClasses)(ratingItemClassNames.fullValueInput, inputBaseClassName, state.halfValueInput && inputStyles.upperHalf, state.fullValueInput.className);
    }
    if (state.unselectedIcon) {
        state.unselectedIcon.className = (0, _react.mergeClasses)(ratingItemClassNames.unselectedIcon, indicatorBaseClassName, appearance === 'filled' && indicatorStyles.filled, color === 'brand' && (appearance === 'filled' ? indicatorStyles.brandFilled : indicatorStyles.brand), color === 'marigold' && (appearance === 'filled' ? indicatorStyles.marigoldFilled : indicatorStyles.marigold), iconFillWidth === 0.5 && indicatorStyles.upperHalf, state.unselectedIcon.className);
    }
    if (state.selectedIcon) {
        state.selectedIcon.className = (0, _react.mergeClasses)(ratingItemClassNames.selectedIcon, indicatorBaseClassName, color === 'brand' && indicatorStyles.brand, color === 'marigold' && indicatorStyles.marigold, iconFillWidth === 0.5 && indicatorStyles.lowerHalf, state.selectedIcon.className);
    }
    return state;
};
