'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ratingItemClassNames: function() {
        return ratingItemClassNames;
    },
    useRatingItemStyles_unstable: function() {
        return useRatingItemStyles_unstable;
    }
});
const _react = require("@griffel/react");
const ratingItemClassNames = {
    root: 'fui-RatingItem',
    selectedIcon: 'fui-RatingItem__selectedIcon',
    unselectedIcon: 'fui-RatingItem__unselectedIcon',
    halfValueInput: 'fui-RatingItem__halfValueInput',
    fullValueInput: 'fui-RatingItem__fullValueInput'
};
/**
 * Styles for the root slot
 */ const useStyles = /*#__PURE__*/ (0, _react.__styles)({
    root: {
        qhf8xq: "f10pi13n",
        Brovlpu: "ftqa4ok",
        B486eqv: "f2hkw1w",
        Bssx7fj: "f1b1k54r",
        uh7if5: [
            "f4ne723",
            "fqqcjud"
        ],
        clntm0: "fh7aioi",
        Dlk2r6: [
            "fqqcjud",
            "f4ne723"
        ],
        Bm3wd5j: "f1k55ka9",
        Bbrhkcr: [
            "fgclinu",
            "f16pcs8n"
        ],
        f1oku: "fycbxed",
        aywvf2: [
            "f16pcs8n",
            "fgclinu"
        ],
        B2j2mmj: "ffht0p2",
        wigs8: "f1p0ul1q",
        pbfy6t: "f1c901ms",
        B0v4ure: "f1alokd7",
        Byrf0fs: 0,
        Bsiemmq: 0,
        Bwckmig: 0,
        skfxo0: 0,
        Iidy0u: 0,
        B98u21t: 0,
        Bvwlmkc: 0,
        jo1ztg: 0,
        Ba1iezr: 0,
        Blmvk6g: 0,
        B24cy0v: 0,
        Bil7v7r: 0,
        Br3gin4: 0,
        nr063g: 0,
        ghq09: 0,
        Bbgo44z: 0,
        Bseh09z: "fmj8fco",
        az1dzo: 0,
        Ba3ybja: 0,
        B6352mv: 0,
        vppk2z: 0,
        Biaj6j7: "f1iwowo3",
        B2pnrqr: "f1spmvte",
        B29w5g4: [
            "fgp7k2s",
            "f13pb23"
        ],
        Bhhzhcn: "f1ihbrwi",
        Bec0n69: [
            "f13pb23",
            "fgp7k2s"
        ]
    },
    small: {
        Be2twd7: "f1ugzwwg",
        a9b677: "frx94fk",
        Bqenvij: "fvblgha"
    },
    medium: {
        Be2twd7: "f4ybsrx",
        a9b677: "fjw5fx7",
        Bqenvij: "fd461yt"
    },
    large: {
        Be2twd7: "fe5j1ua",
        a9b677: "f64fuq3",
        Bqenvij: "fjamq6b"
    },
    "extra-large": {
        Be2twd7: "f24l1pt",
        a9b677: "f1w9dchk",
        Bqenvij: "fxldao9"
    }
}, {
    d: [
        ".f10pi13n{position:relative;}",
        ".f1b1k54r[data-fui-focus-within]:focus-within{border-top-color:transparent;}",
        ".f4ne723[data-fui-focus-within]:focus-within{border-right-color:transparent;}",
        ".fqqcjud[data-fui-focus-within]:focus-within{border-left-color:transparent;}",
        ".fh7aioi[data-fui-focus-within]:focus-within{border-bottom-color:transparent;}",
        ".ffht0p2[data-fui-focus-within]:focus-within::after{content:\"\";}",
        ".f1p0ul1q[data-fui-focus-within]:focus-within::after{position:absolute;}",
        ".f1c901ms[data-fui-focus-within]:focus-within::after{pointer-events:none;}",
        ".f1alokd7[data-fui-focus-within]:focus-within::after{z-index:1;}",
        [
            ".fmj8fco[data-fui-focus-within]:focus-within::after{border:2px solid var(--colorStrokeFocus2);}",
            {
                p: -2
            }
        ],
        [
            ".f1iwowo3[data-fui-focus-within]:focus-within::after{border-radius:var(--borderRadiusMedium);}",
            {
                p: -1
            }
        ],
        ".f1spmvte[data-fui-focus-within]:focus-within::after{top:calc(2px * -1);}",
        ".fgp7k2s[data-fui-focus-within]:focus-within::after{right:calc(2px * -1);}",
        ".f13pb23[data-fui-focus-within]:focus-within::after{left:calc(2px * -1);}",
        ".f1ihbrwi[data-fui-focus-within]:focus-within::after{bottom:calc(2px * -1);}",
        ".f1ugzwwg{font-size:12px;}",
        ".frx94fk{width:12px;}",
        ".fvblgha{height:12px;}",
        ".f4ybsrx{font-size:16px;}",
        ".fjw5fx7{width:16px;}",
        ".fd461yt{height:16px;}",
        ".fe5j1ua{font-size:20px;}",
        ".f64fuq3{width:20px;}",
        ".fjamq6b{height:20px;}",
        ".f24l1pt{font-size:28px;}",
        ".f1w9dchk{width:28px;}",
        ".fxldao9{height:28px;}"
    ],
    f: [
        ".ftqa4ok:focus{outline-style:none;}"
    ],
    i: [
        ".f2hkw1w:focus-visible{outline-style:none;}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f1k55ka9[data-fui-focus-within]:focus-within::after{border-top-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f16pcs8n[data-fui-focus-within]:focus-within::after{border-left-color:Highlight;}.fgclinu[data-fui-focus-within]:focus-within::after{border-right-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.fycbxed[data-fui-focus-within]:focus-within::after{border-bottom-color:Highlight;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ]
});
const useInputBaseClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r1qfsv1p", "rh8pzaz", [
    ".r1qfsv1p{position:absolute;left:0;top:0;right:0;bottom:0;box-sizing:border-box;margin:0;opacity:0;cursor:pointer;height:100%;}",
    ".rh8pzaz{position:absolute;right:0;top:0;left:0;bottom:0;box-sizing:border-box;margin:0;opacity:0;cursor:pointer;height:100%;}"
]);
const useInputStyles = /*#__PURE__*/ (0, _react.__styles)({
    lowerHalf: {
        j35jbq: [
            "ffenbu1",
            "f1ktbn1t"
        ]
    },
    upperHalf: {
        oyh7mz: [
            "f1ktbn1t",
            "ffenbu1"
        ]
    }
}, {
    d: [
        ".ffenbu1{right:50%;}",
        ".f1ktbn1t{left:50%;}"
    ]
});
const useIndicatorBaseClassName = /*#__PURE__*/ (0, _react.__resetStyles)("r1420l2m", "r1yt29v5", [
    ".r1420l2m{display:flex;overflow:hidden;color:var(--colorNeutralForeground1);fill:currentColor;pointer-events:none;position:absolute;left:0;right:0;top:0;bottom:0;}",
    ".r1yt29v5{display:flex;overflow:hidden;color:var(--colorNeutralForeground1);fill:currentColor;pointer-events:none;position:absolute;right:0;left:0;top:0;bottom:0;}"
]);
const useIndicatorStyles = /*#__PURE__*/ (0, _react.__styles)({
    lowerHalf: {
        j35jbq: [
            "ffenbu1",
            "f1ktbn1t"
        ],
        l5kjut: 0,
        uoufgc: 0,
        v39lw8: 0,
        Bbwb3tu: "f10jwh99"
    },
    upperHalf: {
        oyh7mz: [
            "f1ktbn1t",
            "ffenbu1"
        ],
        Frg6f3: [
            "fbm7ezh",
            "f3ev47i"
        ]
    },
    brand: {
        sj55zd: "f16muhyy"
    },
    marigold: {
        sj55zd: "f1whvut0"
    },
    filled: {
        sj55zd: "f1qaymga",
        ojy3ng: "f13qq9og",
        Bbusuzp: "f1cg6951",
        B6jmk37: "f1am6ztc"
    },
    brandFilled: {
        sj55zd: "f1kdv6iu"
    },
    marigoldFilled: {
        sj55zd: "f1ymbmfq"
    }
}, {
    d: [
        ".ffenbu1{right:50%;}",
        ".f1ktbn1t{left:50%;}",
        [
            ".f10jwh99>svg{flex:0 0 auto;}",
            {
                p: -1
            }
        ],
        ".fbm7ezh{margin-left:-50%;}",
        ".f3ev47i{margin-right:-50%;}",
        ".f16muhyy{color:var(--colorBrandForeground1);}",
        ".f1whvut0{color:var(--colorPaletteMarigoldBorderActive);}",
        ".f1qaymga{color:var(--colorNeutralBackground6);}",
        ".f13qq9og{stroke:var(--colorTransparentStroke);}",
        ".f1kdv6iu{color:var(--colorBrandBackground2);}",
        ".f1ymbmfq{color:var(--colorPaletteMarigoldBackground2);}"
    ],
    m: [
        [
            "@media (forced-colors: active){.f1cg6951{color:Canvas;}}",
            {
                m: "(forced-colors: active)"
            }
        ],
        [
            "@media (forced-colors: active){.f1am6ztc{stroke:CanvasText;}}",
            {
                m: "(forced-colors: active)"
            }
        ]
    ]
});
const useRatingItemStyles_unstable = (state)=>{
    'use no memo';
    const { color, size, iconFillWidth, appearance } = state;
    const styles = useStyles();
    const inputBaseClassName = useInputBaseClassName();
    const inputStyles = useInputStyles();
    const indicatorBaseClassName = useIndicatorBaseClassName();
    const indicatorStyles = useIndicatorStyles();
    state.root.className = (0, _react.mergeClasses)(ratingItemClassNames.root, styles.root, styles[size], state.root.className);
    if (state.halfValueInput) {
        state.halfValueInput.className = (0, _react.mergeClasses)(ratingItemClassNames.halfValueInput, inputBaseClassName, inputStyles.lowerHalf, state.halfValueInput.className);
    }
    if (state.fullValueInput) {
        state.fullValueInput.className = (0, _react.mergeClasses)(ratingItemClassNames.fullValueInput, inputBaseClassName, state.halfValueInput && inputStyles.upperHalf, state.fullValueInput.className);
    }
    if (state.unselectedIcon) {
        state.unselectedIcon.className = (0, _react.mergeClasses)(ratingItemClassNames.unselectedIcon, indicatorBaseClassName, appearance === 'filled' && indicatorStyles.filled, color === 'brand' && (appearance === 'filled' ? indicatorStyles.brandFilled : indicatorStyles.brand), color === 'marigold' && (appearance === 'filled' ? indicatorStyles.marigoldFilled : indicatorStyles.marigold), iconFillWidth === 0.5 && indicatorStyles.upperHalf, state.unselectedIcon.className);
    }
    if (state.selectedIcon) {
        state.selectedIcon.className = (0, _react.mergeClasses)(ratingItemClassNames.selectedIcon, indicatorBaseClassName, color === 'brand' && indicatorStyles.brand, color === 'marigold' && indicatorStyles.marigold, iconFillWidth === 0.5 && indicatorStyles.lowerHalf, state.selectedIcon.className);
    }
    return state;
};
