'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useRatingItem_unstable", {
    enumerable: true,
    get: function() {
        return useRatingItem_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const _RatingItemContext = require("../../contexts/RatingItemContext");
const defaultItemLabel = (num)=>num + '';
const useRatingItem_unstable = (props, ref)=>{
    const context = (0, _RatingItemContext.useRatingItemContextValue_unstable)();
    const { value = 0 } = props;
    const { itemLabel = defaultItemLabel, iconFilled: IconFilled, iconOutline: IconOutline } = context;
    const ratingValue = Math.round((context.value || 0) * 2) / 2; // round to the nearest 0.5
    var _context_hoveredValue;
    const displayedRatingValue = (_context_hoveredValue = context.hoveredValue) !== null && _context_hoveredValue !== void 0 ? _context_hoveredValue : ratingValue;
    const appearance = context.interactive ? 'outline' : 'filled';
    let iconFillWidth;
    if (context.compact || displayedRatingValue >= value) {
        iconFillWidth = 1;
    } else if (displayedRatingValue >= value - 0.5) {
        iconFillWidth = 0.5;
    } else {
        iconFillWidth = 0;
    }
    const root = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('span', {
        ref: (0, _reactutilities.useMergedRefs)((0, _reacttabster.useFocusWithin)(), ref),
        ...props
    }), {
        elementType: 'span'
    });
    let unselectedIcon;
    if (iconFillWidth < 1) {
        unselectedIcon = _reactutilities.slot.always(props.unselectedIcon, {
            defaultProps: {
                children: appearance === 'filled' ? /*#__PURE__*/ _react.createElement(IconFilled, null) : /*#__PURE__*/ _react.createElement(IconOutline, null),
                'aria-hidden': true
            },
            elementType: 'div'
        });
    }
    let selectedIcon;
    if (iconFillWidth > 0) {
        selectedIcon = _reactutilities.slot.always(props.selectedIcon, {
            defaultProps: {
                children: /*#__PURE__*/ _react.createElement(IconFilled, null),
                'aria-hidden': true
            },
            elementType: 'div'
        });
    }
    let halfValueInput;
    if (context.interactive && context.step === 0.5) {
        halfValueInput = _reactutilities.slot.always(props.halfValueInput, {
            defaultProps: {
                type: 'radio',
                name: context.name,
                value: value - 0.5,
                checked: ratingValue === value - 0.5,
                'aria-label': itemLabel(value - 0.5),
                onChange: ()=>{
                // This empty onChange handler silences an incorrect React warning about not using onChange for a controlled input.
                // The parent Rating component has the real onChange handler to listen to change events from this input.
                }
            },
            elementType: 'input'
        });
    }
    let fullValueInput;
    if (context.interactive) {
        fullValueInput = _reactutilities.slot.always(props.fullValueInput, {
            defaultProps: {
                type: 'radio',
                name: context.name,
                value,
                checked: ratingValue === value,
                'aria-label': itemLabel(value),
                onChange: ()=>{
                // This empty onChange handler silences an incorrect React warning about not using onChange for a controlled input.
                // The parent Rating component has the real onChange handler to listen to change events from this input.
                }
            },
            elementType: 'input'
        });
    }
    const state = {
        appearance,
        color: context.color,
        step: context.step,
        size: context.size,
        iconFillWidth,
        value,
        components: {
            root: 'span',
            selectedIcon: 'div',
            unselectedIcon: 'div',
            halfValueInput: 'input',
            fullValueInput: 'input'
        },
        root,
        selectedIcon,
        unselectedIcon,
        halfValueInput,
        fullValueInput
    };
    return state;
};
