'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ratingDisplayClassNames: function() {
        return ratingDisplayClassNames;
    },
    useRatingDisplayStyles_unstable: function() {
        return useRatingDisplayStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const ratingDisplayClassNames = {
    root: 'fui-RatingDisplay',
    valueText: 'fui-RatingDisplay__valueText',
    countText: 'fui-RatingDisplay__countText'
};
/**
 * Styles for the root slot
 */ const useRootClassName = (0, _react.makeResetStyles)({
    display: 'flex',
    flexWrap: 'wrap',
    alignItems: 'center'
});
const useLabelClassName = (0, _react.makeResetStyles)({
    color: _reacttheme.tokens.colorNeutralForeground1,
    marginLeft: _reacttheme.tokens.spacingHorizontalXS,
    ..._reacttheme.typographyStyles.caption1
});
const useLabelStyles = (0, _react.makeStyles)({
    large: {
        fontSize: _reacttheme.tokens.fontSizeBase300,
        lineHeight: _reacttheme.tokens.lineHeightBase300,
        marginLeft: _reacttheme.tokens.spacingHorizontalSNudge
    },
    extraLarge: {
        fontSize: _reacttheme.tokens.fontSizeBase400,
        lineHeight: _reacttheme.tokens.lineHeightBase400,
        marginLeft: _reacttheme.tokens.spacingHorizontalS
    },
    strong: {
        fontWeight: _reacttheme.tokens.fontWeightSemibold
    },
    divider: {
        '::before': {
            content: '"· "'
        }
    }
});
const useRatingDisplayStyles_unstable = (state)=>{
    'use no memo';
    const { size } = state;
    const rootClassName = useRootClassName();
    state.root.className = (0, _react.mergeClasses)(ratingDisplayClassNames.root, rootClassName, state.root.className);
    const labelClassName = useLabelClassName();
    const labelStyles = useLabelStyles();
    if (state.valueText) {
        state.valueText.className = (0, _react.mergeClasses)(ratingDisplayClassNames.valueText, labelClassName, labelStyles.strong, size === 'large' && labelStyles.large, size === 'extra-large' && labelStyles.extraLarge, state.valueText.className);
    }
    if (state.countText) {
        state.countText.className = (0, _react.mergeClasses)(ratingDisplayClassNames.countText, labelClassName, size === 'large' && labelStyles.large, size === 'extra-large' && labelStyles.extraLarge, state.valueText && labelStyles.divider, state.countText.className);
    }
    return state;
};
