'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    ratingDisplayClassNames: function() {
        return ratingDisplayClassNames;
    },
    useRatingDisplayStyles_unstable: function() {
        return useRatingDisplayStyles_unstable;
    }
});
const _react = require("@griffel/react");
const ratingDisplayClassNames = {
    root: 'fui-RatingDisplay',
    valueText: 'fui-RatingDisplay__valueText',
    countText: 'fui-RatingDisplay__countText'
};
/**
 * Styles for the root slot
 */ const useRootClassName = /*#__PURE__*/ (0, _react.__resetStyles)("rxxdqwu", null, [
    ".rxxdqwu{display:flex;flex-wrap:wrap;align-items:center;}"
]);
const useLabelClassName = /*#__PURE__*/ (0, _react.__resetStyles)("rkwnos5", "rwei36a", [
    ".rkwnos5{color:var(--colorNeutralForeground1);margin-left:var(--spacingHorizontalXS);font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase200);}",
    ".rwei36a{color:var(--colorNeutralForeground1);margin-right:var(--spacingHorizontalXS);font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase200);}"
]);
const useLabelStyles = /*#__PURE__*/ (0, _react.__styles)({
    large: {
        Be2twd7: "fkhj508",
        Bg96gwp: "f1i3iumi",
        Frg6f3: [
            "f1t5qyk5",
            "f1ikr372"
        ]
    },
    extraLarge: {
        Be2twd7: "fod5ikn",
        Bg96gwp: "faaz57k",
        Frg6f3: [
            "foyynoy",
            "f1vcna3q"
        ]
    },
    strong: {
        Bhrd7zp: "fl43uef"
    },
    divider: {
        Ftih45: "f169p45e"
    }
}, {
    d: [
        ".fkhj508{font-size:var(--fontSizeBase300);}",
        ".f1i3iumi{line-height:var(--lineHeightBase300);}",
        ".f1t5qyk5{margin-left:var(--spacingHorizontalSNudge);}",
        ".f1ikr372{margin-right:var(--spacingHorizontalSNudge);}",
        ".fod5ikn{font-size:var(--fontSizeBase400);}",
        ".faaz57k{line-height:var(--lineHeightBase400);}",
        ".foyynoy{margin-left:var(--spacingHorizontalS);}",
        ".f1vcna3q{margin-right:var(--spacingHorizontalS);}",
        ".fl43uef{font-weight:var(--fontWeightSemibold);}",
        ".f169p45e::before{content:\"\xB7 \";}"
    ]
});
const useRatingDisplayStyles_unstable = (state)=>{
    'use no memo';
    const { size } = state;
    const rootClassName = useRootClassName();
    state.root.className = (0, _react.mergeClasses)(ratingDisplayClassNames.root, rootClassName, state.root.className);
    const labelClassName = useLabelClassName();
    const labelStyles = useLabelStyles();
    if (state.valueText) {
        state.valueText.className = (0, _react.mergeClasses)(ratingDisplayClassNames.valueText, labelClassName, labelStyles.strong, size === 'large' && labelStyles.large, size === 'extra-large' && labelStyles.extraLarge, state.valueText.className);
    }
    if (state.countText) {
        state.countText.className = (0, _react.mergeClasses)(ratingDisplayClassNames.countText, labelClassName, size === 'large' && labelStyles.large, size === 'extra-large' && labelStyles.extraLarge, state.valueText && labelStyles.divider, state.countText.className);
    }
    return state;
};
