'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useRatingDisplay_unstable", {
    enumerable: true,
    get: function() {
        return useRatingDisplay_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacticons = require("@fluentui/react-icons");
const _RatingItem = require("../RatingItem/RatingItem");
const useRatingDisplay_unstable = (props, ref)=>{
    const { color = 'neutral', count, compact = false, icon = _reacticons.StarFilled, max = 5, size = 'medium', value } = props;
    const valueTextId = (0, _reactutilities.useId)('rating-value-');
    const countTextId = (0, _reactutilities.useId)('rating-count-');
    // Generate the child RatingItems and memoize them to prevent unnecessary re-rendering
    const rootChildren = _react.useMemo(()=>{
        return compact ? /*#__PURE__*/ _react.createElement(_RatingItem.RatingItem, {
            value: 1,
            key: 1,
            "aria-hidden": true
        }) : Array.from(Array(max), (_, i)=>/*#__PURE__*/ _react.createElement(_RatingItem.RatingItem, {
                value: i + 1,
                key: i + 1,
                "aria-hidden": true
            }));
    }, [
        compact,
        max
    ]);
    const state = {
        color,
        compact,
        icon,
        max,
        size,
        value,
        components: {
            root: 'div',
            valueText: 'span',
            countText: 'span'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            children: rootChildren,
            role: 'img',
            ...props
        }), {
            elementType: 'div'
        }),
        valueText: _reactutilities.slot.optional(props.valueText, {
            renderByDefault: value !== undefined,
            defaultProps: {
                children: value,
                id: valueTextId,
                'aria-hidden': true
            },
            elementType: 'span'
        }),
        countText: _reactutilities.slot.optional(props.countText, {
            renderByDefault: count !== undefined,
            defaultProps: {
                children: count === null || count === void 0 ? void 0 : count.toLocaleString(),
                id: countTextId,
                'aria-hidden': true
            },
            elementType: 'span'
        })
    };
    if (!state.root['aria-label'] && !state.root['aria-labelledby']) {
        var _state_valueText, _state_countText;
        state.root['aria-labelledby'] = [
            (_state_valueText = state.valueText) === null || _state_valueText === void 0 ? void 0 : _state_valueText.id,
            (_state_countText = state.countText) === null || _state_countText === void 0 ? void 0 : _state_countText.id
        ].filter(Boolean).join(' ');
    }
    return state;
};
