'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useRating_unstable", {
    enumerable: true,
    get: function() {
        return useRating_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _RatingItem = require("../../RatingItem");
const _reacticons = require("@fluentui/react-icons");
const useRating_unstable = (props, ref)=>{
    const generatedName = (0, _reactutilities.useId)('rating-');
    const { color = 'neutral', iconFilled = _reacticons.StarFilled, iconOutline = _reacticons.StarRegular, max = 5, name = generatedName, onChange, step = 1, size = 'extra-large', itemLabel } = props;
    const [value, setValue] = (0, _reactutilities.useControllableState)({
        state: props.value,
        defaultState: props.defaultValue,
        initialState: 0
    });
    const isRatingRadioItem = (target)=>(0, _reactutilities.isHTMLElement)(target, {
            constructorName: 'HTMLInputElement'
        }) && target.type === 'radio' && target.name === name;
    const [hoveredValue, setHoveredValue] = _react.useState(undefined);
    // Generate the child RatingItems and memoize them to prevent unnecessary re-rendering
    const rootChildren = _react.useMemo(()=>{
        return Array.from(Array(max), (_, i)=>/*#__PURE__*/ _react.createElement(_RatingItem.RatingItem, {
                value: i + 1,
                key: i + 1
            }));
    }, [
        max
    ]);
    const state = {
        color,
        iconFilled,
        iconOutline,
        name,
        step,
        size,
        itemLabel,
        value,
        hoveredValue,
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ref,
            children: rootChildren,
            role: 'radiogroup',
            ...props
        }, [
            'onChange'
        ]), {
            elementType: 'div'
        })
    };
    state.root.onChange = (ev)=>{
        if (isRatingRadioItem(ev.target)) {
            const newValue = parseFloat(ev.target.value);
            if (!isNaN(newValue)) {
                setValue(newValue);
                onChange === null || onChange === void 0 ? void 0 : onChange(ev, {
                    type: 'change',
                    event: ev,
                    value: newValue
                });
            }
        }
    };
    state.root.onMouseOver = (0, _reactutilities.mergeCallbacks)(props.onMouseOver, (ev)=>{
        if (isRatingRadioItem(ev.target)) {
            const newValue = parseFloat(ev.target.value);
            if (!isNaN(newValue)) {
                setHoveredValue(newValue);
            }
        }
    });
    state.root.onMouseLeave = (0, _reactutilities.mergeCallbacks)(props.onMouseLeave, (ev)=>{
        setHoveredValue(undefined);
    });
    return state;
};
