import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { EventData } from '@fluentui/react-utilities';
import type { EventHandler } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Rating is a wrapper for one or more rating items that will be used to set a rating value.
 */
export declare const Rating: ForwardRefComponent<RatingProps>;

export declare const ratingClassNames: SlotClassNames<RatingSlots>;

export declare type RatingContextValues = {
    ratingItem: RatingItemContextValue;
};

/**
 * RatingDisplay is a wrapper for one or more rating items that will be used to display a rating value
 * as well as the label for the rating.
 */
export declare const RatingDisplay: ForwardRefComponent<RatingDisplayProps>;

export declare const ratingDisplayClassNames: SlotClassNames<RatingDisplaySlots>;

export declare type RatingDisplayContextValues = {
    ratingItem: RatingItemContextValue;
};

/**
 * RatingDisplay Props
 */
export declare type RatingDisplayProps = ComponentProps<RatingDisplaySlots> & {
    /**
     * Color of the rating items (stars).
     * @default neutral
     */
    color?: 'brand' | 'marigold' | 'neutral';
    /**
     * Renders a single filled star, with the value written next to it.
     * @default false
     */
    compact?: boolean;
    /**
     * The number of ratings represented by the rating value.
     * This will be formatted with a thousands separator (if applicable) and displayed next to the value.
     */
    count?: number;
    /**
     * The icon used for rating items.
     * @default StarFilled
     */
    icon?: React_2.ElementType;
    /**
     * The max value of the rating. This controls the number of rating items displayed.
     * Must be a whole number greater than 1.
     * @default 5
     */
    max?: number;
    /**
     * Sets the size of the RatingDisplay items.
     * @default medium
     */
    size?: 'small' | 'medium' | 'large' | 'extra-large';
    /**
     * The value of the rating
     */
    value?: number;
};

export declare type RatingDisplaySlots = {
    root: NonNullable<Slot<'div'>>;
    valueText?: Slot<'span'>;
    countText?: Slot<'span'>;
};

/**
 * State used in rendering RatingDisplay
 */
export declare type RatingDisplayState = ComponentState<RatingDisplaySlots> & Required<Pick<RatingDisplayProps, 'color' | 'compact' | 'icon' | 'max' | 'size'>> & Pick<RatingDisplayProps, 'value'>;

/**
 * RatingItem is an item that will be used to set or display a rating value.
 */
export declare const RatingItem: ForwardRefComponent<RatingItemProps>;

export declare const ratingItemClassNames: SlotClassNames<RatingItemSlots>;

declare type RatingItemContextValue = Partial<Pick<RatingState, 'name' | 'hoveredValue' | 'value'>> & Pick<RatingState, 'color' | 'iconFilled' | 'iconOutline' | 'itemLabel' | 'step' | 'size'> & Partial<Pick<RatingDisplayState, 'compact'>> & {
    interactive?: boolean;
};

/**
 * RatingItem Props
 */
export declare type RatingItemProps = ComponentProps<Partial<RatingItemSlots>> & {
    /**
     * The positive whole number value that is displayed by this RatingItem
     */
    value?: number;
};

export declare const RatingItemProvider: React_2.Provider<RatingItemContextValue | undefined>;

export declare type RatingItemSlots = {
    /**
     * The root slot of the RatingItem.
     * Default html element is span
     */
    root: NonNullable<Slot<'span'>>;
    /**
     * Icon displayed when the rating value is greater than or equal to the item's value.
     */
    selectedIcon?: NonNullable<Slot<'div'>>;
    /**
     * Icon displayed when the rating value is less than the item's value.
     */
    unselectedIcon?: NonNullable<Slot<'div'>>;
    /**
     * Radio input slot used for half star precision
     */
    halfValueInput?: NonNullable<Slot<'input'>>;
    /**
     * Radio input slot used for full star precision
     */
    fullValueInput?: NonNullable<Slot<'input'>>;
};

/**
 * State used in rendering RatingItem
 */
export declare type RatingItemState = ComponentState<RatingItemSlots> & Required<Pick<RatingItemProps, 'value'>> & Pick<RatingState, 'color' | 'step' | 'size'> & {
    iconFillWidth: number;
    appearance: 'outline' | 'filled';
};

/**
 * Data for the onChange event for Rating.
 */
export declare type RatingOnChangeEventData = EventData<'change', React_2.FormEvent<HTMLDivElement>> & {
    /**
     * The new value of the rating.
     */
    value: number;
};

/**
 * Rating Props
 */
export declare type RatingProps = Omit<ComponentProps<Partial<RatingSlots>>, 'onChange'> & {
    /**
     * Controls the color of the Rating.
     * @default neutral
     */
    color?: 'brand' | 'marigold' | 'neutral';
    /**
     * Default value of the Rating
     */
    defaultValue?: number;
    /**
     * The icon to display when the rating value is greater than or equal to the item's value.
     */
    iconFilled?: React_2.ElementType;
    /**
     * The icon to display when the rating value is less than the item's value.
     */
    iconOutline?: React_2.ElementType;
    /**
     * Prop to generate the aria-label for the rating inputs.
     * @default (rating) =\> `${rating}`
     */
    itemLabel?: (rating: number) => string;
    /**
     * The max value of the rating. This controls the number of rating items displayed.
     * Must be a whole number greater than 1.
     * @default 5
     */
    max?: number;
    /**
     * Name for the Radio inputs. If not provided, one will be automatically generated
     */
    name?: string;
    /**
     * Callback when the rating value is changed by the user.
     */
    onChange?: EventHandler<RatingOnChangeEventData>;
    /**
     * Sets the precision to allow half-filled shapes in Rating
     * @default 1
     */
    step?: 0.5 | 1;
    /**
     * Sets the size of the Rating items.
     * @default extra-large
     */
    size?: 'small' | 'medium' | 'large' | 'extra-large';
    /**
     * The value of the rating
     */
    value?: number;
};

export declare type RatingSlots = {
    root: NonNullable<Slot<'div'>>;
};

/**
 * State used in rendering Rating
 */
export declare type RatingState = ComponentState<RatingSlots> & Required<Pick<RatingProps, 'color' | 'iconFilled' | 'iconOutline' | 'name' | 'step' | 'size' | 'value'>> & Pick<RatingProps, 'itemLabel'> & {
    hoveredValue?: number | undefined;
};

/**
 * Render the final JSX of Rating
 */
export declare const renderRating_unstable: (state: RatingState, contextValues: RatingContextValues) => JSXElement;

/**
 * Render the final JSX of RatingDisplay
 */
export declare const renderRatingDisplay_unstable: (state: RatingDisplayState, contextValues: RatingDisplayContextValues) => JSXElement;

/**
 * Render the final JSX of RatingItem
 */
export declare const renderRatingItem_unstable: (state: RatingItemState) => JSXElement;

/**
 * Create the state required to render Rating.
 *
 * The returned state can be modified with hooks such as useRatingStyles_unstable,
 * before being passed to renderRating_unstable.
 *
 * @param props - props from this instance of Rating
 * @param ref - reference to root HTMLElement of Rating
 */
export declare const useRating_unstable: (props: RatingProps, ref: React_2.Ref<HTMLDivElement>) => RatingState;

export declare const useRatingContextValues: (ratingState: RatingState) => RatingContextValues;

/**
 * Create the state required to render RatingDisplay.
 *
 * The returned state can be modified with hooks such as useRatingDisplayStyles_unstable,
 * before being passed to renderRatingDisplay_unstable.
 *
 * @param props - props from this instance of RatingDisplay
 * @param ref - reference to root HTMLDivElement of RatingDisplay
 */
export declare const useRatingDisplay_unstable: (props: RatingDisplayProps, ref: React_2.Ref<HTMLDivElement>) => RatingDisplayState;

export declare const useRatingDisplayContextValues: (state: RatingDisplayState) => RatingDisplayContextValues;

/**
 * Apply styling to the RatingDisplay slots based on the state
 */
export declare const useRatingDisplayStyles_unstable: (state: RatingDisplayState) => RatingDisplayState;

/**
 * Create the state required to render RatingItem.
 *
 * The returned state can be modified with hooks such as useRatingItemStyles_unstable,
 * before being passed to renderRatingItem_unstable.
 *
 * @param props - props from this instance of RatingItem
 * @param ref - reference to root HTMLElement of RatingItem
 */
export declare const useRatingItem_unstable: (props: RatingItemProps, ref: React_2.Ref<HTMLSpanElement>) => RatingItemState;

/**
 * Get the value of the RatingContext.
 */
export declare const useRatingItemContextValue_unstable: () => RatingItemContextValue;

/**
 * Apply styling to the RatingItem slots based on the state
 */
export declare const useRatingItemStyles_unstable: (state: RatingItemState) => RatingItemState;

/**
 * Apply styling to the Rating slots based on the state
 */
export declare const useRatingStyles_unstable: (state: RatingState) => RatingState;

export { }
