# @fluentui/react-rating

**React Rating components for [Fluent UI React](https://react.fluentui.dev)**

A `Rating` component allows users to provide a rating for a particular item.

This component displays a set of stars or other symbols that represent the rating value. Users can interact with the component to select a rating by clicking on the stars or using touch gestures.

### Usage

Import `Rating` or `RatingDisplay`:

```js
// From @fluentui/react-components
import { Rating, RatingDisplay } from '@fluentui/react-components';

// Directly from @fluentui/react-rating
import { Rating, RatingDisplay } from '@fluentui/react-rating';
```

#### Examples

```jsx
<Rating />

<RatingDisplay />
```

See [Fluent UI Storybook](https://react.fluentui.dev/) for more detailed usage examples.

Alternatively, run Storybook locally with:

1. `yarn start`
2. Select `react-rating` from the list.

### Specification

See [Spec.md](./docs/Spec.md).
