'use client';
import * as React from 'react';
export const useRadioGroupContextValues = (state)=>{
    const { name, value, defaultValue, disabled, layout, required } = state;
    const ariaDescribedBy = state.root['aria-describedby'];
    const radioGroup = React.useMemo(()=>({
            name,
            value,
            defaultValue,
            disabled,
            layout,
            required,
            'aria-describedby': ariaDescribedBy
        }), [
        name,
        value,
        defaultValue,
        disabled,
        layout,
        required,
        ariaDescribedBy
    ]);
    return {
        radioGroup
    };
};
