'use client';

import { createFocusOutlineStyle } from '@fluentui/react-tabster';
import { tokens } from '@fluentui/react-theme';
import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
export const radioClassNames = {
  root: 'fui-Radio',
  indicator: 'fui-Radio__indicator',
  input: 'fui-Radio__input',
  label: 'fui-Radio__label'
};
// The indicator size is used by the indicator and label styles
const indicatorSize = '16px';
const useRootBaseClassName = /*#__PURE__*/__resetStyles("r1siqwd8", "rmnplyc", {
  r: [".r1siqwd8{display:inline-flex;position:relative;}", ".r1siqwd8:focus{outline-style:none;}", ".r1siqwd8:focus-visible{outline-style:none;}", ".r1siqwd8[data-fui-focus-within]:focus-within{border-top-color:transparent;border-right-color:transparent;border-bottom-color:transparent;border-left-color:transparent;}", ".r1siqwd8[data-fui-focus-within]:focus-within::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);right:calc(2px * -1);bottom:calc(2px * -1);left:calc(2px * -1);}", ".rmnplyc{display:inline-flex;position:relative;}", ".rmnplyc:focus{outline-style:none;}", ".rmnplyc:focus-visible{outline-style:none;}", ".rmnplyc[data-fui-focus-within]:focus-within{border-top-color:transparent;border-left-color:transparent;border-bottom-color:transparent;border-right-color:transparent;}", ".rmnplyc[data-fui-focus-within]:focus-within::after{content:\"\";position:absolute;pointer-events:none;z-index:1;border:2px solid var(--colorStrokeFocus2);border-radius:var(--borderRadiusMedium);top:calc(2px * -1);left:calc(2px * -1);bottom:calc(2px * -1);right:calc(2px * -1);}"],
  s: ["@media (forced-colors: active){.r1siqwd8[data-fui-focus-within]:focus-within::after{border-top-color:Highlight;border-right-color:Highlight;border-bottom-color:Highlight;border-left-color:Highlight;}}", "@media (forced-colors: active){.rmnplyc[data-fui-focus-within]:focus-within::after{border-top-color:Highlight;border-left-color:Highlight;border-bottom-color:Highlight;border-right-color:Highlight;}}"]
});
const useRootStyles = /*#__PURE__*/__styles({
  vertical: {
    Beiy3e4: "f1vx9l62",
    Bt984gj: "f122n59"
  }
}, {
  d: [".f1vx9l62{flex-direction:column;}", ".f122n59{align-items:center;}"]
});
const useInputBaseClassName = /*#__PURE__*/__resetStyles("rg1upok", "rzwdzb4", {
  r: [".rg1upok{position:absolute;left:0;top:0;width:calc(16px + 2 * var(--spacingHorizontalS));height:100%;box-sizing:border-box;margin:0;opacity:0;}", ".rg1upok:enabled{cursor:pointer;}", ".rg1upok:enabled~.fui-Radio__label{cursor:pointer;}", ".rg1upok:enabled:not(:checked)~.fui-Radio__label{color:var(--colorNeutralForeground3);}", ".rg1upok:enabled:not(:checked)~.fui-Radio__indicator{border-color:var(--colorNeutralStrokeAccessible);}", ".rg1upok:enabled:not(:checked):hover~.fui-Radio__label{color:var(--colorNeutralForeground2);}", ".rg1upok:enabled:not(:checked):hover~.fui-Radio__indicator{border-color:var(--colorNeutralStrokeAccessibleHover);}", ".rg1upok:enabled:not(:checked):hover:active~.fui-Radio__label{color:var(--colorNeutralForeground1);}", ".rg1upok:enabled:not(:checked):hover:active~.fui-Radio__indicator{border-color:var(--colorNeutralStrokeAccessiblePressed);}", ".rg1upok:enabled:checked~.fui-Radio__label{color:var(--colorNeutralForeground1);}", ".rg1upok:enabled:checked~.fui-Radio__indicator{border-color:var(--colorCompoundBrandStroke);color:var(--colorCompoundBrandForeground1);}", ".rg1upok:enabled:checked:hover~.fui-Radio__indicator{border-color:var(--colorCompoundBrandStrokeHover);color:var(--colorCompoundBrandForeground1Hover);}", ".rg1upok:enabled:checked:hover:active~.fui-Radio__indicator{border-color:var(--colorCompoundBrandStrokePressed);color:var(--colorCompoundBrandForeground1Pressed);}", ".rg1upok:disabled~.fui-Radio__label{color:var(--colorNeutralForegroundDisabled);cursor:default;}", ".rg1upok:disabled~.fui-Radio__indicator{border-color:var(--colorNeutralStrokeDisabled);color:var(--colorNeutralForegroundDisabled);}", ".rzwdzb4{position:absolute;right:0;top:0;width:calc(16px + 2 * var(--spacingHorizontalS));height:100%;box-sizing:border-box;margin:0;opacity:0;}", ".rzwdzb4:enabled{cursor:pointer;}", ".rzwdzb4:enabled~.fui-Radio__label{cursor:pointer;}", ".rzwdzb4:enabled:not(:checked)~.fui-Radio__label{color:var(--colorNeutralForeground3);}", ".rzwdzb4:enabled:not(:checked)~.fui-Radio__indicator{border-color:var(--colorNeutralStrokeAccessible);}", ".rzwdzb4:enabled:not(:checked):hover~.fui-Radio__label{color:var(--colorNeutralForeground2);}", ".rzwdzb4:enabled:not(:checked):hover~.fui-Radio__indicator{border-color:var(--colorNeutralStrokeAccessibleHover);}", ".rzwdzb4:enabled:not(:checked):hover:active~.fui-Radio__label{color:var(--colorNeutralForeground1);}", ".rzwdzb4:enabled:not(:checked):hover:active~.fui-Radio__indicator{border-color:var(--colorNeutralStrokeAccessiblePressed);}", ".rzwdzb4:enabled:checked~.fui-Radio__label{color:var(--colorNeutralForeground1);}", ".rzwdzb4:enabled:checked~.fui-Radio__indicator{border-color:var(--colorCompoundBrandStroke);color:var(--colorCompoundBrandForeground1);}", ".rzwdzb4:enabled:checked:hover~.fui-Radio__indicator{border-color:var(--colorCompoundBrandStrokeHover);color:var(--colorCompoundBrandForeground1Hover);}", ".rzwdzb4:enabled:checked:hover:active~.fui-Radio__indicator{border-color:var(--colorCompoundBrandStrokePressed);color:var(--colorCompoundBrandForeground1Pressed);}", ".rzwdzb4:disabled~.fui-Radio__label{color:var(--colorNeutralForegroundDisabled);cursor:default;}", ".rzwdzb4:disabled~.fui-Radio__indicator{border-color:var(--colorNeutralStrokeDisabled);color:var(--colorNeutralForegroundDisabled);}"],
  s: ["@media (forced-colors: active){.rg1upok:enabled:not(:checked)~.fui-Radio__indicator{border-color:ButtonBorder;}}", "@media (forced-colors: active){.rg1upok:enabled:checked~.fui-Radio__indicator{border-color:Highlight;color:Highlight;}.rg1upok:enabled:checked~.fui-Radio__indicator::after{background-color:Highlight;}}", "@media (forced-colors: active){.rg1upok:disabled~.fui-Radio__label{color:GrayText;}}", "@media (forced-colors: active){.rg1upok:disabled~.fui-Radio__indicator{border-color:GrayText;color:GrayText;}.rg1upok:disabled~.fui-Radio__indicator::after{background-color:GrayText;}}", "@media (forced-colors: active){.rzwdzb4:enabled:not(:checked)~.fui-Radio__indicator{border-color:ButtonBorder;}}", "@media (forced-colors: active){.rzwdzb4:enabled:checked~.fui-Radio__indicator{border-color:Highlight;color:Highlight;}.rzwdzb4:enabled:checked~.fui-Radio__indicator::after{background-color:Highlight;}}", "@media (forced-colors: active){.rzwdzb4:disabled~.fui-Radio__label{color:GrayText;}}", "@media (forced-colors: active){.rzwdzb4:disabled~.fui-Radio__indicator{border-color:GrayText;color:GrayText;}.rzwdzb4:disabled~.fui-Radio__indicator::after{background-color:GrayText;}}"]
});
const useInputStyles = /*#__PURE__*/__styles({
  below: {
    a9b677: "fly5x3f",
    Bqenvij: "f1je6zif"
  },
  defaultIndicator: {
    Blbys7f: "f9ma1gx"
  },
  customIndicator: {
    Bj53wkj: "f12zxao0"
  }
}, {
  d: [".fly5x3f{width:100%;}", ".f1je6zif{height:calc(16px + 2 * var(--spacingVerticalS));}", ".f9ma1gx:checked~.fui-Radio__indicator::after{content:\"\";}", ".f12zxao0:not(:checked)~.fui-Radio__indicator>*{opacity:0;}"]
});
const useIndicatorBaseClassName = /*#__PURE__*/__resetStyles("rwtekvw", null, [".rwtekvw{position:relative;width:16px;height:16px;font-size:12px;box-sizing:border-box;flex-shrink:0;display:flex;align-items:center;justify-content:center;overflow:hidden;border:var(--strokeWidthThin) solid;border-radius:var(--borderRadiusCircular);margin:var(--spacingVerticalS) var(--spacingHorizontalS);fill:currentColor;pointer-events:none;}", ".rwtekvw::after{position:absolute;width:16px;height:16px;border-radius:var(--borderRadiusCircular);transform:scale(0.625);background-color:currentColor;}"]);
// Can't use makeResetStyles here because Label is a component that may itself use makeResetStyles.
const useLabelStyles = /*#__PURE__*/__styles({
  base: {
    qb2dma: "f7nlbp4",
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1f5q0n8"
  },
  after: {
    uwmqm3: ["fruq291", "f7x41pl"],
    B6of3ja: "fjzwpt6",
    jrapky: "fh6j2fo"
  },
  below: {
    z8tnut: "f1ywm7hm",
    fsow6f: "f17mccla"
  }
}, {
  d: [".f7nlbp4{align-self:center;}", [".f1f5q0n8{padding:var(--spacingVerticalS) var(--spacingHorizontalS);}", {
    p: -1
  }], ".fruq291{padding-left:var(--spacingHorizontalXS);}", ".f7x41pl{padding-right:var(--spacingHorizontalXS);}", ".fjzwpt6{margin-top:calc((16px - var(--lineHeightBase300)) / 2);}", ".fh6j2fo{margin-bottom:calc((16px - var(--lineHeightBase300)) / 2);}", ".f1ywm7hm{padding-top:var(--spacingVerticalXS);}", ".f17mccla{text-align:center;}"]
});
/**
 * Apply styling to the Radio slots based on the state
 */
export const useRadioStyles_unstable = state => {
  'use no memo';

  const {
    labelPosition
  } = state;
  const rootBaseClassName = useRootBaseClassName();
  const rootStyles = useRootStyles();
  state.root.className = mergeClasses(radioClassNames.root, rootBaseClassName, labelPosition === 'below' && rootStyles.vertical, state.root.className);
  const inputBaseClassName = useInputBaseClassName();
  const inputStyles = useInputStyles();
  state.input.className = mergeClasses(radioClassNames.input, inputBaseClassName, labelPosition === 'below' && inputStyles.below, state.indicator.children ? inputStyles.customIndicator : inputStyles.defaultIndicator, state.input.className);
  const indicatorBaseClassName = useIndicatorBaseClassName();
  state.indicator.className = mergeClasses(radioClassNames.indicator, indicatorBaseClassName, state.indicator.className);
  const labelStyles = useLabelStyles();
  if (state.label) {
    state.label.className = mergeClasses(radioClassNames.label, labelStyles.base, labelStyles[labelPosition], state.label.className);
  }
  return state;
};