'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useRadioGroupContextValues", {
    enumerable: true,
    get: function() {
        return useRadioGroupContextValues;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const useRadioGroupContextValues = (state)=>{
    const { name, value, defaultValue, disabled, layout, required } = state;
    const ariaDescribedBy = state.root['aria-describedby'];
    const radioGroup = _react.useMemo(()=>({
            name,
            value,
            defaultValue,
            disabled,
            layout,
            required,
            'aria-describedby': ariaDescribedBy
        }), [
        name,
        value,
        defaultValue,
        disabled,
        layout,
        required,
        ariaDescribedBy
    ]);
    return {
        radioGroup
    };
};
