'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useRadioGroup_unstable", {
    enumerable: true,
    get: function() {
        return useRadioGroup_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reactutilities = require("@fluentui/react-utilities");
const useRadioGroup_unstable = (props, ref)=>{
    // Merge props from surrounding <Field>, if any
    props = (0, _reactfield.useFieldControlProps_unstable)(props);
    const generatedName = (0, _reactutilities.useId)('radiogroup-');
    const { name = generatedName, value, defaultValue, disabled, layout = 'vertical', onChange, required } = props;
    return {
        layout,
        name,
        value,
        defaultValue,
        disabled,
        required,
        components: {
            root: 'div'
        },
        root: {
            ref,
            role: 'radiogroup',
            ..._reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', props, /*excludedPropNames:*/ [
                'onChange',
                'name'
            ]), {
                elementType: 'div'
            }),
            onChange: (0, _reactutilities.useEventCallback)((ev)=>{
                if (onChange && (0, _reactutilities.isHTMLElement)(ev.target, {
                    constructorName: 'HTMLInputElement'
                }) && ev.target.type === 'radio') {
                    onChange(ev, {
                        value: ev.target.value
                    });
                }
            })
        }
    };
};
