'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    radioClassNames: function() {
        return radioClassNames;
    },
    useRadioStyles_unstable: function() {
        return useRadioStyles_unstable;
    }
});
const _reacttabster = require("@fluentui/react-tabster");
const _reacttheme = require("@fluentui/react-theme");
const _react = require("@griffel/react");
const radioClassNames = {
    root: 'fui-Radio',
    indicator: 'fui-Radio__indicator',
    input: 'fui-Radio__input',
    label: 'fui-Radio__label'
};
// The indicator size is used by the indicator and label styles
const indicatorSize = '16px';
const useRootBaseClassName = (0, _react.makeResetStyles)({
    display: 'inline-flex',
    position: 'relative',
    ...(0, _reacttabster.createFocusOutlineStyle)({
        style: {},
        selector: 'focus-within'
    })
});
const useRootStyles = (0, _react.makeStyles)({
    vertical: {
        flexDirection: 'column',
        alignItems: 'center'
    }
});
const useInputBaseClassName = (0, _react.makeResetStyles)({
    position: 'absolute',
    left: 0,
    top: 0,
    width: `calc(${indicatorSize} + 2 * ${_reacttheme.tokens.spacingHorizontalS})`,
    height: '100%',
    boxSizing: 'border-box',
    margin: 0,
    opacity: 0,
    ':enabled': {
        cursor: 'pointer',
        [`& ~ .${radioClassNames.label}`]: {
            cursor: 'pointer'
        }
    },
    // Colors for the unchecked state
    ':enabled:not(:checked)': {
        [`& ~ .${radioClassNames.label}`]: {
            color: _reacttheme.tokens.colorNeutralForeground3
        },
        [`& ~ .${radioClassNames.indicator}`]: {
            borderColor: _reacttheme.tokens.colorNeutralStrokeAccessible,
            '@media (forced-colors: active)': {
                borderColor: 'ButtonBorder'
            }
        },
        ':hover': {
            [`& ~ .${radioClassNames.label}`]: {
                color: _reacttheme.tokens.colorNeutralForeground2
            },
            [`& ~ .${radioClassNames.indicator}`]: {
                borderColor: _reacttheme.tokens.colorNeutralStrokeAccessibleHover
            }
        },
        ':hover:active': {
            [`& ~ .${radioClassNames.label}`]: {
                color: _reacttheme.tokens.colorNeutralForeground1
            },
            [`& ~ .${radioClassNames.indicator}`]: {
                borderColor: _reacttheme.tokens.colorNeutralStrokeAccessiblePressed
            }
        }
    },
    // Colors for the checked state
    ':enabled:checked': {
        [`& ~ .${radioClassNames.label}`]: {
            color: _reacttheme.tokens.colorNeutralForeground1
        },
        [`& ~ .${radioClassNames.indicator}`]: {
            borderColor: _reacttheme.tokens.colorCompoundBrandStroke,
            color: _reacttheme.tokens.colorCompoundBrandForeground1,
            '@media (forced-colors: active)': {
                borderColor: 'Highlight',
                color: 'Highlight',
                '::after': {
                    backgroundColor: 'Highlight'
                }
            }
        },
        ':hover': {
            [`& ~ .${radioClassNames.indicator}`]: {
                borderColor: _reacttheme.tokens.colorCompoundBrandStrokeHover,
                color: _reacttheme.tokens.colorCompoundBrandForeground1Hover
            }
        },
        ':hover:active': {
            [`& ~ .${radioClassNames.indicator}`]: {
                borderColor: _reacttheme.tokens.colorCompoundBrandStrokePressed,
                color: _reacttheme.tokens.colorCompoundBrandForeground1Pressed
            }
        }
    },
    // Colors for the disabled state
    ':disabled': {
        [`& ~ .${radioClassNames.label}`]: {
            color: _reacttheme.tokens.colorNeutralForegroundDisabled,
            cursor: 'default',
            '@media (forced-colors: active)': {
                color: 'GrayText'
            }
        },
        [`& ~ .${radioClassNames.indicator}`]: {
            borderColor: _reacttheme.tokens.colorNeutralStrokeDisabled,
            color: _reacttheme.tokens.colorNeutralForegroundDisabled,
            '@media (forced-colors: active)': {
                borderColor: 'GrayText',
                color: 'GrayText',
                '::after': {
                    backgroundColor: 'GrayText'
                }
            }
        }
    }
});
const useInputStyles = (0, _react.makeStyles)({
    below: {
        width: '100%',
        height: `calc(${indicatorSize} + 2 * ${_reacttheme.tokens.spacingVerticalS})`
    },
    // If the indicator has no children, use the ::after pseudo-element for the checked state
    defaultIndicator: {
        [`:checked ~ .${radioClassNames.indicator}::after`]: {
            content: '""'
        }
    },
    // If the indicator has a child, hide it until the radio is checked
    customIndicator: {
        [`:not(:checked) ~ .${radioClassNames.indicator} > *`]: {
            opacity: '0'
        }
    }
});
const useIndicatorBaseClassName = (0, _react.makeResetStyles)({
    position: 'relative',
    width: indicatorSize,
    height: indicatorSize,
    fontSize: '12px',
    boxSizing: 'border-box',
    flexShrink: 0,
    display: 'flex',
    alignItems: 'center',
    justifyContent: 'center',
    overflow: 'hidden',
    border: _reacttheme.tokens.strokeWidthThin + ' solid',
    borderRadius: _reacttheme.tokens.borderRadiusCircular,
    margin: _reacttheme.tokens.spacingVerticalS + ' ' + _reacttheme.tokens.spacingHorizontalS,
    fill: 'currentColor',
    pointerEvents: 'none',
    '::after': {
        position: 'absolute',
        width: indicatorSize,
        height: indicatorSize,
        borderRadius: _reacttheme.tokens.borderRadiusCircular,
        // Use a transform to avoid pixel rounding errors at 125% DPI
        // https://github.com/microsoft/fluentui/issues/30025
        transform: 'scale(0.625)',
        backgroundColor: 'currentColor'
    }
});
// Can't use makeResetStyles here because Label is a component that may itself use makeResetStyles.
const useLabelStyles = (0, _react.makeStyles)({
    base: {
        alignSelf: 'center',
        padding: `${_reacttheme.tokens.spacingVerticalS} ${_reacttheme.tokens.spacingHorizontalS}`
    },
    after: {
        paddingLeft: _reacttheme.tokens.spacingHorizontalXS,
        // Use a (negative) margin to account for the difference between the indicator's height and the label's line height.
        // This prevents the label from expanding the height of the Radio, but preserves line height if the label wraps.
        marginTop: `calc((${indicatorSize} - ${_reacttheme.tokens.lineHeightBase300}) / 2)`,
        marginBottom: `calc((${indicatorSize} - ${_reacttheme.tokens.lineHeightBase300}) / 2)`
    },
    below: {
        paddingTop: _reacttheme.tokens.spacingVerticalXS,
        textAlign: 'center'
    }
});
const useRadioStyles_unstable = (state)=>{
    'use no memo';
    const { labelPosition } = state;
    const rootBaseClassName = useRootBaseClassName();
    const rootStyles = useRootStyles();
    state.root.className = (0, _react.mergeClasses)(radioClassNames.root, rootBaseClassName, labelPosition === 'below' && rootStyles.vertical, state.root.className);
    const inputBaseClassName = useInputBaseClassName();
    const inputStyles = useInputStyles();
    state.input.className = (0, _react.mergeClasses)(radioClassNames.input, inputBaseClassName, labelPosition === 'below' && inputStyles.below, state.indicator.children ? inputStyles.customIndicator : inputStyles.defaultIndicator, state.input.className);
    const indicatorBaseClassName = useIndicatorBaseClassName();
    state.indicator.className = (0, _react.mergeClasses)(radioClassNames.indicator, indicatorBaseClassName, state.indicator.className);
    const labelStyles = useLabelStyles();
    if (state.label) {
        state.label.className = (0, _react.mergeClasses)(radioClassNames.label, labelStyles.base, labelStyles[labelPosition], state.label.className);
    }
    return state;
};
