'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useRadio_unstable", {
    enumerable: true,
    get: function() {
        return useRadio_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactlabel = require("@fluentui/react-label");
const _reactutilities = require("@fluentui/react-utilities");
const _RadioGroupContext = require("../../contexts/RadioGroupContext");
const _reacttabster = require("@fluentui/react-tabster");
const useRadio_unstable = (props, ref)=>{
    const group = (0, _RadioGroupContext.useRadioGroupContextValue_unstable)();
    const { name = group.name, checked = group.value !== undefined ? group.value === props.value : undefined, defaultChecked = group.defaultValue !== undefined ? group.defaultValue === props.value : undefined, labelPosition = group.layout === 'horizontal-stacked' ? 'below' : 'after', disabled = group.disabled, required = group.required, 'aria-describedby': ariaDescribedBy = group['aria-describedby'], onChange } = props;
    const nativeProps = (0, _reactutilities.getPartitionedNativeProps)({
        props,
        primarySlotTagName: 'input',
        excludedPropNames: [
            'checked',
            'defaultChecked',
            'onChange'
        ]
    });
    const root = _reactutilities.slot.always(props.root, {
        defaultProps: {
            ref: (0, _reacttabster.useFocusWithin)(),
            ...nativeProps.root
        },
        elementType: 'span'
    });
    const input = _reactutilities.slot.always(props.input, {
        defaultProps: {
            ref,
            type: 'radio',
            id: (0, _reactutilities.useId)('radio-', nativeProps.primary.id),
            name,
            checked,
            defaultChecked,
            disabled,
            required,
            'aria-describedby': ariaDescribedBy,
            ...nativeProps.primary
        },
        elementType: 'input'
    });
    input.onChange = (0, _reactutilities.mergeCallbacks)(input.onChange, (ev)=>onChange === null || onChange === void 0 ? void 0 : onChange(ev, {
            value: ev.currentTarget.value
        }));
    const label = _reactutilities.slot.optional(props.label, {
        defaultProps: {
            htmlFor: input.id,
            disabled: input.disabled
        },
        elementType: _reactlabel.Label
    });
    const indicator = _reactutilities.slot.always(props.indicator, {
        defaultProps: {
            'aria-hidden': true
        },
        elementType: 'div'
    });
    return {
        labelPosition,
        components: {
            root: 'span',
            input: 'input',
            label: _reactlabel.Label,
            indicator: 'div'
        },
        root,
        input,
        label,
        indicator
    };
};
