import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import { Label } from '@fluentui/react-label';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * Radio component is a wrapper for a radio button with a label.
 */
export declare const Radio: ForwardRefComponent<RadioProps>;

export declare const radioClassNames: SlotClassNames<RadioSlots>;

/**
 * A RadioGroup component presents a set of options where only one option can be selected.
 */
export declare const RadioGroup: ForwardRefComponent<RadioGroupProps>;

export declare const radioGroupClassNames: SlotClassNames<RadioGroupSlots>;

export declare type RadioGroupContextValue = Pick<RadioGroupProps, 'name' | 'value' | 'defaultValue' | 'disabled' | 'layout' | 'required' | 'aria-describedby'>;

export declare type RadioGroupContextValues = {
    radioGroup: RadioGroupContextValue;
};

/**
 * Data for the onChange event for RadioGroup.
 */
export declare type RadioGroupOnChangeData = {
    /**
     * The value of the newly selected Radio item.
     */
    value: string;
};

export declare type RadioGroupProps = Omit<ComponentProps<Partial<RadioGroupSlots>>, 'onChange'> & {
    /**
     * The name of this radio group. This name is applied to all Radio items inside this group.
     *
     * If no name is provided, one will be generated so that all of the Radio items have the same name.
     */
    name?: string;
    /**
     * The selected Radio item in this group.
     *
     * This should be the `value` prop of one of the Radio items inside this group.
     */
    value?: string;
    /**
     * The default selected Radio item in this group.
     *
     * This should be the `value` prop of one of the Radio items inside this group.
     */
    defaultValue?: string;
    /**
     * Callback when the selected Radio item changes.
     */
    onChange?: (ev: React_2.FormEvent<HTMLDivElement>, data: RadioGroupOnChangeData) => void;
    /**
     * How the radio items are laid out in the group.
     *
     * @default vertical
     */
    layout?: 'vertical' | 'horizontal' | 'horizontal-stacked';
    /**
     * Disable all Radio items in this group.
     */
    disabled?: boolean;
    /**
     * Require a selection in this group. Adds the `required` prop to all child Radio items.
     */
    required?: boolean;
};

export declare const RadioGroupProvider: React_2.Provider<RadioGroupContextValue | undefined>;

export declare type RadioGroupSlots = {
    /**
     * The radio group root.
     */
    root: NonNullable<Slot<'div'>>;
};

/**
 * State used in rendering RadioGroup
 */
export declare type RadioGroupState = ComponentState<RadioGroupSlots> & Required<Pick<RadioGroupProps, 'layout'>> & Pick<RadioGroupProps, 'name' | 'value' | 'defaultValue' | 'disabled' | 'layout' | 'required'>;

/**
 * Data for the onChange event for Radio.
 */
export declare type RadioOnChangeData = {
    /**
     * The value prop of this Radio item.
     */
    value: string;
};

/**
 * Radio Props
 */
export declare type RadioProps = Omit<ComponentProps<Partial<RadioSlots>, 'input'>, 'onChange' | 'size'> & {
    /**
     * The value of the RadioGroup when this Radio item is selected.
     */
    value?: string;
    /**
     * The position of the label relative to the radio indicator.
     *
     * This defaults to `after` unless the Radio is inside a RadioGroup with `layout="horizontalStacked"`,
     * in which case it defaults to `below`.
     *
     * @defaultvalue after
     */
    labelPosition?: 'after' | 'below';
    /**
     * Disable this Radio item.
     */
    disabled?: boolean;
    /**
     * Callback when this Radio is selected in its group.
     *
     * **Note:** `onChange` is NOT called when this Radio is deselected.
     * Use RadioGroup's `onChange` event to determine when the selection in the group changes.
     */
    onChange?: (ev: React_2.ChangeEvent<HTMLInputElement>, data: RadioOnChangeData) => void;
};

export declare type RadioSlots = {
    /**
     * The root element of the Radio.
     *
     * The root slot receives the `className` and `style` specified directly on the `<Radio>`.
     * All other native props will be applied to the primary slot: `input`
     */
    root: NonNullable<Slot<'span'>>;
    /**
     * The Radio's label.
     */
    label: Slot<typeof Label>;
    /**
     * Hidden input that handles the radio's functionality.
     *
     * This is the PRIMARY slot: all native properties specified directly on `<Radio>` will be applied to this slot,
     * except `className` and `style`, which remain on the root slot.
     */
    input: NonNullable<Slot<'input'>>;
    /**
     * A circle outline, with a filled circle icon inside when the Radio is checked.
     */
    indicator: NonNullable<Slot<'div'>>;
};

/**
 * State used in rendering Radio
 */
export declare type RadioState = ComponentState<RadioSlots> & Required<Pick<RadioProps, 'labelPosition'>>;

/**
 * Render the final JSX of Radio
 */
export declare const renderRadio_unstable: (state: RadioState) => JSXElement;

/**
 * Render the final JSX of RadioGroup
 */
export declare const renderRadioGroup_unstable: (state: RadioGroupState, contextValues: RadioGroupContextValues) => JSXElement;

/**
 * Create the state required to render Radio.
 *
 * The returned state can be modified with hooks such as useRadioStyles_unstable,
 * before being passed to renderRadio_unstable.
 *
 * @param props - props from this instance of Radio
 * @param ref - reference to `<input>` element of Radio
 */
export declare const useRadio_unstable: (props: RadioProps, ref: React_2.Ref<HTMLInputElement>) => RadioState;

/**
 * Create the state required to render RadioGroup.
 *
 * The returned state can be modified with hooks such as useRadioGroupStyles_unstable,
 * before being passed to renderRadioGroup_unstable.
 *
 * @param props - props from this instance of RadioGroup
 * @param ref - reference to root HTMLElement of RadioGroup
 */
export declare const useRadioGroup_unstable: (props: RadioGroupProps, ref: React_2.Ref<HTMLDivElement>) => RadioGroupState;

/**
 * @deprecated Use useRadioGroupContextValue_unstable instead.
 * RadioGroupContext is no longer a selector context, and no longer benefits from having a selector.
 */
export declare const useRadioGroupContext_unstable: <T>(selector: (ctx: RadioGroupContextValue) => T) => T;

/**
 * Get the value of the RadioGroupContext.
 */
export declare const useRadioGroupContextValue_unstable: () => RadioGroupContextValue;

export declare const useRadioGroupContextValues: (state: RadioGroupState) => RadioGroupContextValues;

/**
 * Apply styling to the RadioGroup slots based on the state
 */
export declare const useRadioGroupStyles_unstable: (state: RadioGroupState) => RadioGroupState;

/**
 * Apply styling to the Radio slots based on the state
 */
export declare const useRadioStyles_unstable: (state: RadioState) => RadioState;

export { }
