  import { jsx as _jsx, jsxs as _jsxs } from "@fluentui/react-jsx-runtime/jsx-runtime";
import { canUseDOM, assertSlots } from '@fluentui/react-utilities';
import { TextDirectionProvider } from '@griffel/react';
import { OverridesProvider_unstable as OverridesProvider, Provider_unstable as Provider, TooltipVisibilityProvider_unstable as TooltipVisibilityProvider, ThemeProvider_unstable as ThemeProvider, ThemeClassNameProvider_unstable as ThemeClassNameProvider, CustomStyleHooksProvider_unstable as CustomStyleHooksProvider } from '@fluentui/react-shared-contexts';
import { IconDirectionContextProvider } from '@fluentui/react-icons/lib/providers';
/**
 * Render the final JSX of FluentProvider
 */ export const renderFluentProvider_unstable = (state, contextValues)=>{
    assertSlots(state);
    // Typescript (vscode) incorrectly references the FluentProviderProps.customStyleHooks_unstable
    // instead of FluentProviderContextValues.customStyleHooks_unstable and thinks it is
    // Partial<CustomStyleHooksContextValue>, so it needs to be cast to Required<CustomStyleHooksContextValue>
    return /*#__PURE__*/ _jsx(Provider, {
        value: contextValues.provider,
        children: /*#__PURE__*/ _jsx(ThemeProvider, {
            value: contextValues.theme,
            children: /*#__PURE__*/ _jsx(ThemeClassNameProvider, {
                value: contextValues.themeClassName,
                children: /*#__PURE__*/ _jsx(CustomStyleHooksProvider, {
                    value: contextValues.customStyleHooks_unstable,
                    children: /*#__PURE__*/ _jsx(TooltipVisibilityProvider, {
                        value: contextValues.tooltip,
                        children: /*#__PURE__*/ _jsx(TextDirectionProvider, {
                            dir: contextValues.textDirection,
                            children: /*#__PURE__*/ _jsx(IconDirectionContextProvider, {
                                value: contextValues.iconDirection,
                                children: /*#__PURE__*/ _jsx(OverridesProvider, {
                                    value: contextValues.overrides_unstable,
                                    children: /*#__PURE__*/ _jsxs(state.root, {
                                        children: [
                                            canUseDOM() ? null : /*#__PURE__*/ _jsx("style", {
                                                // Using dangerous HTML because react can escape characters
                                                // which can lead to invalid CSS.
                                                // eslint-disable-next-line react/no-danger
                                                dangerouslySetInnerHTML: {
                                                    __html: state.serverStyleProps.cssRule
                                                },
                                                ...state.serverStyleProps.attributes
                                            }),
                                            state.root.children
                                        ]
                                    })
                                })
                            })
                        })
                    })
                })
            })
        })
    });
};
