'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    fluentProviderClassNames: function() {
        return fluentProviderClassNames;
    },
    useFluentProviderStyles_unstable: function() {
        return useFluentProviderStyles_unstable;
    }
});
const _core = require("@griffel/core");
const _react = require("@griffel/react");
const _reacttheme = require("@fluentui/react-theme");
const fluentProviderClassNames = {
    root: 'fui-FluentProvider'
};
const useStyles = (0, _core.makeStyles)({
    root: {
        color: _reacttheme.tokens.colorNeutralForeground1,
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        textAlign: 'left',
        ..._reacttheme.typographyStyles.body1
    }
});
const useFluentProviderStyles_unstable = (state)=>{
    'use no memo';
    const renderer = (0, _react.useRenderer_unstable)();
    const styles = useStyles({
        dir: state.dir,
        renderer
    });
    state.root.className = (0, _core.mergeClasses)(fluentProviderClassNames.root, state.themeClassName, styles.root, state.root.className);
    return state;
};
