'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useFluentProvider_unstable", {
    enumerable: true,
    get: function() {
        return useFluentProvider_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = require("@griffel/react");
const _reacttabster = require("@fluentui/react-tabster");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _reactutilities = require("@fluentui/react-utilities");
const _react1 = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _useFluentProviderThemeStyleTag = require("./useFluentProviderThemeStyleTag");
// Meomizing empty objects to avoid unnecessary rerenders.
const DEFAULT_STYLE_HOOKS = {};
const DEFAULT_RENDERER_ATTRIBUTES = {};
const useFluentProvider_unstable = (props, ref)=>{
    'use no memo';
    const parentContext = (0, _reactsharedcontexts.useFluent_unstable)();
    const parentTheme = useTheme();
    const parentOverrides = (0, _reactsharedcontexts.useOverrides_unstable)();
    const parentCustomStyleHooks = _react1.useContext(_reactsharedcontexts.CustomStyleHooksContext_unstable) || DEFAULT_STYLE_HOOKS;
    /**
   * TODO: add merge functions to "dir" merge,
   * nesting providers with the same "dir" should not add additional attributes to DOM
   * see https://github.com/microsoft/fluentui/blob/0dc74a19f3aa5a058224c20505016fbdb84db172/packages/fluentui/react-northstar/src/utils/mergeProviderContexts.ts#L89-L93
   */ const { applyStylesToPortals = true, customStyleHooks_unstable, dir = parentContext.dir, targetDocument = parentContext.targetDocument, theme, overrides_unstable: overrides = {} } = props;
    const mergedTheme = shallowMerge(parentTheme, theme);
    const mergedOverrides = shallowMerge(parentOverrides, overrides);
    const mergedCustomStyleHooks = shallowMerge(parentCustomStyleHooks, customStyleHooks_unstable);
    const renderer = (0, _react.useRenderer_unstable)();
    var _renderer_styleElementAttributes;
    const { styleTagId, rule } = (0, _useFluentProviderThemeStyleTag.useFluentProviderThemeStyleTag)({
        theme: mergedTheme,
        targetDocument,
        rendererAttributes: (_renderer_styleElementAttributes = renderer.styleElementAttributes) !== null && _renderer_styleElementAttributes !== void 0 ? _renderer_styleElementAttributes : DEFAULT_RENDERER_ATTRIBUTES
    });
    if (process.env.NODE_ENV !== 'production') {
        // eslint-disable-next-line react-hooks/rules-of-hooks
        _react1.useEffect(()=>{
            if (mergedTheme === undefined) {
                // eslint-disable-next-line no-console
                console.warn([
                    '@fluentui/react-provider: FluentProvider does not have your "theme" defined.',
                    "Make sure that your top-level FluentProvider has set a `theme` prop or you're setting the theme in your child FluentProvider."
                ].join(' '));
            }
        // eslint-disable-next-line react-hooks/exhaustive-deps
        }, []);
    }
    return {
        applyStylesToPortals,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        customStyleHooks_unstable: mergedCustomStyleHooks,
        dir,
        targetDocument,
        theme: mergedTheme,
        // eslint-disable-next-line @typescript-eslint/naming-convention
        overrides_unstable: mergedOverrides,
        themeClassName: styleTagId,
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            ...props,
            dir,
            // FIXME:
            // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, (0, _reacttabster.useFocusVisible)({
                targetDocument
            }))
        }), {
            elementType: 'div'
        }),
        serverStyleProps: {
            cssRule: rule,
            attributes: {
                ...renderer.styleElementAttributes,
                id: styleTagId
            }
        }
    };
};
function shallowMerge(a, b) {
    // Merge impacts perf: we should like to avoid it if it's possible
    if (a && b) {
        return {
            ...a,
            ...b
        };
    }
    if (a) {
        return a;
    }
    return b;
}
function useTheme() {
    return _react1.useContext(_reactsharedcontexts.ThemeContext_unstable);
}
