import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { CustomStyleHooksContextValue_unstable } from '@fluentui/react-shared-contexts';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { IconDirectionContextValue } from '@fluentui/react-icons/lib/providers';
import type { JSXElement } from '@fluentui/react-utilities';
import type { OverridesContextValue_unstable } from '@fluentui/react-shared-contexts';
import type { PartialTheme } from '@fluentui/react-theme';
import type { ProviderContextValue_unstable } from '@fluentui/react-shared-contexts';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import { SlotClassNames } from '@fluentui/react-utilities';
import type { ThemeClassNameContextValue_unstable } from '@fluentui/react-shared-contexts';
import type { ThemeContextValue_unstable } from '@fluentui/react-shared-contexts';
import type { TooltipVisibilityContextValue_unstable } from '@fluentui/react-shared-contexts';

/**
 * Creates a CSS rule from a theme object.
 *
 * Useful for scenarios when you want to apply theming statically to a top level elements like `body`.
 */
export declare function createCSSRuleFromTheme(selector: string, theme: PartialTheme | undefined): string;

export declare const FluentProvider: ForwardRefComponent<FluentProviderProps>;

export declare const fluentProviderClassNames: SlotClassNames<FluentProviderSlots>;

export declare type FluentProviderContextValues = Pick<FluentProviderState, 'customStyleHooks_unstable' | 'theme' | 'overrides_unstable'> & {
    provider: ProviderContextValue_unstable;
    themeClassName: ThemeClassNameContextValue_unstable;
    textDirection: 'ltr' | 'rtl';
    iconDirection: IconDirectionContextValue;
    tooltip: TooltipVisibilityContextValue_unstable;
};

export declare type FluentProviderCustomStyleHooks = CustomStyleHooksContextValue_unstable;

export declare type FluentProviderProps = Omit<ComponentProps<FluentProviderSlots>, 'dir'> & {
    /**
     * Passes styles applied to a component down to portals if enabled.
     * @default true
     */
    applyStylesToPortals?: boolean;
    /** Sets the hooks for custom styling components. */
    customStyleHooks_unstable?: FluentProviderCustomStyleHooks;
    /** Sets the direction of text & generated styles. */
    dir?: 'ltr' | 'rtl';
    /** Provides the document, can be undefined during SSR render. */
    targetDocument?: Document;
    /** Sets the theme used in a scope. */
    theme?: PartialTheme;
    overrides_unstable?: OverridesContextValue_unstable;
};

export declare type FluentProviderSlots = {
    root: Slot<'div'>;
};

export declare type FluentProviderState = ComponentState<FluentProviderSlots> & Pick<FluentProviderProps, 'targetDocument'> & Required<Pick<FluentProviderProps, 'applyStylesToPortals' | 'customStyleHooks_unstable' | 'dir' | 'overrides_unstable'>> & {
    theme: ThemeContextValue_unstable;
    themeClassName: string;
    /**
     * Props used to render SSR theme variables style element
     */
    serverStyleProps: {
        /**
         * CSS rule containing CSS variables
         */
        cssRule: string;
        /**
         * Additional attributes applied to the style element
         */
        attributes: Record<string, string>;
    };
};

/**
 * Render the final JSX of FluentProvider
 */
export declare const renderFluentProvider_unstable: (state: FluentProviderState, contextValues: FluentProviderContextValues) => JSXElement;

/**
 * Create the state required to render FluentProvider.
 *
 * The returned state can be modified with hooks such as useFluentProviderStyles_unstable,
 * before being passed to renderFluentProvider_unstable.
 *
 * @param props - props from this instance of FluentProvider
 * @param ref - reference to root HTMLElement of FluentProvider
 */
export declare const useFluentProvider_unstable: (props: FluentProviderProps, ref: React_2.Ref<HTMLElement>) => FluentProviderState;

export declare function useFluentProviderContextValues_unstable(state: FluentProviderState): FluentProviderContextValues;

/** Applies style classnames to slots */
export declare const useFluentProviderStyles_unstable: (state: FluentProviderState) => FluentProviderState;

/**
 * Writes a theme as css variables in a style tag on the provided targetDocument as a rule applied to a CSS class
 * @internal
 * @returns CSS class to apply the rule
 */
export declare const useFluentProviderThemeStyleTag: (options: Pick<FluentProviderState, "theme" | "targetDocument"> & {
    rendererAttributes: Record<string, string>;
}) => {
    styleTagId: string;
    rule: string;
};

export { }
