'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useProgressBar_unstable", {
    enumerable: true,
    get: function() {
        return useProgressBar_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactfield = require("@fluentui/react-field");
const _reactutilities = require("@fluentui/react-utilities");
const _index = require("../../utils/index");
const useProgressBar_unstable = (props, ref)=>{
    const field = (0, _reactfield.useFieldContext_unstable)();
    const fieldState = field === null || field === void 0 ? void 0 : field.validationState;
    const { color = fieldState === 'error' || fieldState === 'warning' || fieldState === 'success' ? fieldState : 'brand', shape = 'rounded', thickness = 'medium' } = props;
    var _props_max;
    const max = (0, _index.clampMax)((_props_max = props.max) !== null && _props_max !== void 0 ? _props_max : 1);
    const value = (0, _index.clampValue)(props.value, max);
    const root = _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
        // FIXME:
        // `ref` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
        // but since it would be a breaking change to fix it, we are casting ref to it's proper type
        ref: ref,
        role: 'progressbar',
        'aria-valuemin': value !== undefined ? 0 : undefined,
        'aria-valuemax': value !== undefined ? max : undefined,
        'aria-valuenow': value,
        'aria-labelledby': field === null || field === void 0 ? void 0 : field.labelId,
        ...props
    }), {
        elementType: 'div'
    });
    if (field && (field.validationMessageId || field.hintId)) {
        // Prepend the field's validation message and/or hint to the user's aria-describedby
        root['aria-describedby'] = [
            field === null || field === void 0 ? void 0 : field.validationMessageId,
            field === null || field === void 0 ? void 0 : field.hintId,
            root['aria-describedby']
        ].filter(Boolean).join(' ');
    }
    const bar = _reactutilities.slot.always(props.bar, {
        elementType: 'div'
    });
    const state = {
        color,
        max,
        shape,
        thickness,
        value,
        components: {
            root: 'div',
            bar: 'div'
        },
        root,
        bar
    };
    return state;
};
