import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import * as React_2 from 'react';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';

/**
 * A ProgressBar bar shows the progression of a task.
 */
export declare const ProgressBar: ForwardRefComponent<ProgressBarProps>;

export declare const progressBarClassNames: SlotClassNames<ProgressBarSlots>;

/**
 * ProgressBar Props
 */
export declare type ProgressBarProps = Omit<ComponentProps<ProgressBarSlots>, 'size'> & {
    /**
     * The shape of the bar and track.
     * @default rounded
     */
    shape?: 'rounded' | 'square';
    /**
     * A decimal number between `0` and `1` (or between `0` and `max` if given),
     * which specifies how much of the task has been completed.
     *
     * If `undefined` (default), the ProgressBar will display an **indeterminate** state.
     */
    value?: number;
    /**
     * The maximum value, which indicates the task is complete.
     * The ProgressBar bar will be full when `value` equals `max`.
     * @default 1
     */
    max?: number;
    /**
     * The thickness of the ProgressBar bar
     * @default medium
     */
    thickness?: 'medium' | 'large';
    /**
     * The status of the ProgressBar bar. Changes the color of the bar.
     * @default brand
     */
    color?: 'brand' | 'success' | 'warning' | 'error';
};

export declare type ProgressBarSlots = {
    /**
     * The track behind the ProgressBar bar
     */
    root: NonNullable<Slot<'div'>>;
    /**
     * The filled portion of the ProgressBar bar. Animated in the indeterminate state, when no value is provided.
     */
    bar?: NonNullable<Slot<'div'>>;
};

/**
 * State used in rendering ProgressBar
 */
export declare type ProgressBarState = ComponentState<Required<ProgressBarSlots>> & Required<Pick<ProgressBarProps, 'max' | 'shape' | 'thickness'>> & Pick<ProgressBarProps, 'value' | 'color'>;

/**
 * Render the final JSX of ProgressBar
 */
export declare const renderProgressBar_unstable: (state: ProgressBarState) => JSXElement;

/**
 * Create the state required to render ProgressBar.
 *
 * The returned state can be modified with hooks such as useProgressBarStyles_unstable,
 * before being passed to renderProgressBar_unstable.
 *
 * @param props - props from this instance of ProgressBar
 * @param ref - reference to root HTMLElement of ProgressBar
 */
export declare const useProgressBar_unstable: (props: ProgressBarProps, ref: React_2.Ref<HTMLElement>) => ProgressBarState;

/**
 * Apply styling to the ProgressBar slots based on the state
 */
export declare const useProgressBarStyles_unstable: (state: ProgressBarState) => ProgressBarState;

export { }
