/**
 * Writes all DOM element updates after position is computed
 */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "writeArrowUpdates", {
    enumerable: true,
    get: function() {
        return writeArrowUpdates;
    }
});
function writeArrowUpdates(options) {
    const { arrow, middlewareData } = options;
    if (!middlewareData.arrow || !arrow) {
        return;
    }
    const { x: arrowX, y: arrowY } = middlewareData.arrow;
    Object.assign(arrow.style, {
        left: arrowX !== null && arrowX !== undefined ? `${arrowX}px` : '',
        top: arrowY !== null && arrowY !== undefined ? `${arrowY}px` : ''
    });
}
