'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useCallbackRef", {
    enumerable: true,
    get: function() {
        return useCallbackRef;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
function useCallbackRef(initialValue, callback, skipInitialResolve) {
    const isFirst = _react.useRef(true);
    const [ref] = _react.useState(()=>({
            // value
            value: initialValue,
            // last callback
            callback,
            // "memoized" public interface
            facade: {
                get current () {
                    return ref.value;
                },
                set current (value){
                    const last = ref.value;
                    if (last !== value) {
                        ref.value = value;
                        if (skipInitialResolve && isFirst.current) {
                            return;
                        }
                        ref.callback(value, last);
                    }
                }
            }
        }));
    (0, _reactutilities.useIsomorphicLayoutEffect)(()=>{
        isFirst.current = false;
    }, []);
    // update callback
    ref.callback = callback;
    return ref.facade;
}
