/**
 * Parses Floating UI placement and returns the different components
 * @param placement - the floating ui placement (i.e. bottom-start)
 *
 * @returns side and alignment components of the placement
 */ "use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "parseFloatingUIPlacement", {
    enumerable: true,
    get: function() {
        return parseFloatingUIPlacement;
    }
});
function parseFloatingUIPlacement(placement) {
    const tokens = placement.split('-');
    return {
        side: tokens[0],
        alignment: tokens[1]
    };
}
