/**
 * Returns the parent node or the host of the node argument.
 * @param node - DOM node.
 * @returns - parent DOM node.
 */ 'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    getParentNode: function() {
        return getParentNode;
    },
    getScrollParent: function() {
        return getScrollParent;
    },
    getStyleComputedProperty: function() {
        return getStyleComputedProperty;
    },
    hasScrollParent: function() {
        return hasScrollParent;
    }
});
const getParentNode = (node)=>{
    if (node.nodeName === 'HTML') {
        return node;
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    return node.parentNode || node.host;
};
const getStyleComputedProperty = (node)=>{
    var _node_ownerDocument;
    if (node.nodeType !== 1) {
        return {};
    }
    const targetWindow = (_node_ownerDocument = node.ownerDocument) === null || _node_ownerDocument === void 0 ? void 0 : _node_ownerDocument.defaultView;
    if (targetWindow) {
        return targetWindow.getComputedStyle(node, null);
    }
    return {};
};
const getScrollParent = (node)=>{
    // Return body, `getScroll` will take care to get the correct `scrollTop` from it
    const parentNode = node && getParentNode(node);
    // eslint-disable-next-line
    if (!parentNode) return document.body;
    switch(parentNode.nodeName){
        case 'HTML':
        case 'BODY':
            return parentNode.ownerDocument.body;
        case '#document':
            return parentNode.body;
    }
    // If any of the overflow props is defined for the node then we return it as the parent
    const { overflow, overflowX, overflowY } = getStyleComputedProperty(parentNode);
    if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
        return parentNode;
    }
    return getScrollParent(parentNode);
};
const hasScrollParent = (node)=>{
    var _scrollParentElement_ownerDocument;
    const scrollParentElement = getScrollParent(node);
    return scrollParentElement ? scrollParentElement !== ((_scrollParentElement_ownerDocument = scrollParentElement.ownerDocument) === null || _scrollParentElement_ownerDocument === void 0 ? void 0 : _scrollParentElement_ownerDocument.body) : false;
};
