"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getFloatingUIOffset", {
    enumerable: true,
    get: function() {
        return getFloatingUIOffset;
    }
});
const _fromFloatingUIPlacement = require("./fromFloatingUIPlacement");
function getFloatingUIOffset(rawOffset) {
    if (!rawOffset) {
        return rawOffset;
    }
    if (typeof rawOffset === 'number' || typeof rawOffset === 'object') {
        return rawOffset;
    }
    return ({ rects: { floating, reference }, placement })=>{
        const { position, alignment } = (0, _fromFloatingUIPlacement.fromFloatingUIPlacement)(placement);
        return rawOffset({
            positionedRect: floating,
            targetRect: reference,
            position,
            alignment
        });
    };
}
