"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "getBoundary", {
    enumerable: true,
    get: function() {
        return getBoundary;
    }
});
const _getScrollParent = require("./getScrollParent");
function getBoundary(element, boundary) {
    if (boundary === 'window') {
        return element === null || element === void 0 ? void 0 : element.ownerDocument.documentElement;
    }
    if (boundary === 'clippingParents') {
        return 'clippingAncestors';
    }
    if (boundary === 'scrollParent') {
        let boundariesNode = (0, _getScrollParent.getScrollParent)(element);
        if (boundariesNode.nodeName === 'BODY') {
            boundariesNode = element === null || element === void 0 ? void 0 : element.ownerDocument.documentElement;
        }
        return boundariesNode;
    }
    return boundary;
}
