'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "usePositioningOptions", {
    enumerable: true,
    get: function() {
        return usePositioningOptions;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _devtools = require("@floating-ui/devtools");
const _dom = require("@floating-ui/dom");
const _reactsharedcontexts = require("@fluentui/react-shared-contexts");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _middleware = require("./middleware");
const _utils = require("./utils");
const _devtools1 = require("./utils/devtools");
const _PositioningConfigurationContext = require("./PositioningConfigurationContext");
/**
 * @internal
 *
 * This is redundant and exists only to manage React dependencies properly & avoid leaking individual options to the
 * scope of `usePositioningOptions`.
 */ function usePositioningConfigFn(configFn, options) {
    const { align, arrowPadding, autoSize, coverTarget, disableUpdateOnResize, flipBoundary, offset, overflowBoundary, pinned, position, unstable_disableTether, strategy, overflowBoundaryPadding, fallbackPositions, useTransform, matchTargetSize, shiftToCoverTarget } = options;
    return _react.useCallback((container, arrow)=>{
        return configFn({
            container,
            arrow,
            options: {
                autoSize,
                disableUpdateOnResize,
                matchTargetSize,
                offset,
                strategy,
                coverTarget,
                flipBoundary,
                overflowBoundary,
                useTransform,
                overflowBoundaryPadding,
                pinned,
                arrowPadding,
                align,
                fallbackPositions,
                shiftToCoverTarget,
                position,
                // eslint-disable-next-line @typescript-eslint/naming-convention
                unstable_disableTether
            }
        });
    }, [
        autoSize,
        disableUpdateOnResize,
        matchTargetSize,
        offset,
        strategy,
        coverTarget,
        flipBoundary,
        overflowBoundary,
        useTransform,
        overflowBoundaryPadding,
        pinned,
        arrowPadding,
        align,
        fallbackPositions,
        shiftToCoverTarget,
        position,
        unstable_disableTether,
        configFn
    ]);
}
function usePositioningOptions(options) {
    const { dir, targetDocument } = (0, _reactsharedcontexts.useFluent_unstable)();
    const isRtl = dir === 'rtl';
    const configFn = usePositioningConfigFn((0, _PositioningConfigurationContext.usePositioningConfiguration)(), options);
    const { positionFixed } = options;
    return _react.useCallback((container, arrow)=>{
        const hasScrollableElement = (0, _utils.hasScrollParent)(container);
        const optionsAfterEnhancement = configFn(container, arrow);
        const { autoSize, disableUpdateOnResize, matchTargetSize, offset, coverTarget, flipBoundary, overflowBoundary, useTransform, overflowBoundaryPadding, pinned, position, arrowPadding, strategy, align, fallbackPositions, shiftToCoverTarget, unstable_disableTether } = optionsAfterEnhancement;
        const normalizedAutoSize = (0, _utils.normalizeAutoSize)(autoSize);
        const middleware = [
            normalizedAutoSize && (0, _middleware.resetMaxSize)(normalizedAutoSize),
            matchTargetSize && (0, _middleware.matchTargetSize)(),
            offset && (0, _middleware.offset)(offset),
            coverTarget && (0, _middleware.coverTarget)(),
            !pinned && (0, _middleware.flip)({
                container,
                flipBoundary,
                hasScrollableElement,
                isRtl,
                fallbackPositions
            }),
            (0, _middleware.shift)({
                container,
                hasScrollableElement,
                overflowBoundary,
                disableTether: unstable_disableTether,
                overflowBoundaryPadding,
                isRtl,
                shiftToCoverTarget
            }),
            normalizedAutoSize && (0, _middleware.maxSize)(normalizedAutoSize, {
                container,
                overflowBoundary,
                overflowBoundaryPadding,
                isRtl
            }),
            (0, _middleware.intersecting)(),
            arrow && (0, _dom.arrow)({
                element: arrow,
                padding: arrowPadding
            }),
            (0, _dom.hide)({
                strategy: 'referenceHidden'
            }),
            (0, _dom.hide)({
                strategy: 'escaped'
            }),
            process.env.NODE_ENV !== 'production' && targetDocument && (0, _devtools.devtools)(targetDocument, (0, _devtools1.devtoolsCallback)(optionsAfterEnhancement))
        ].filter(Boolean);
        const placement = (0, _utils.toFloatingUIPlacement)(align, position, isRtl);
        return {
            placement,
            middleware,
            strategy: (strategy !== null && strategy !== void 0 ? strategy : positionFixed) ? 'fixed' : 'absolute',
            disableUpdateOnResize,
            useTransform
        };
    }, [
        configFn,
        isRtl,
        targetDocument,
        positionFixed
    ]);
}
