'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "usePositioningMouseTarget", {
    enumerable: true,
    get: function() {
        return usePositioningMouseTarget;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _createVirtualElementFromClick = require("./createVirtualElementFromClick");
const usePositioningMouseTarget = (initialState)=>{
    const [virtualElement, setVirtualElement] = _react.useState(initialState);
    const setVirtualMouseTarget = (event)=>{
        if (event === undefined || event === null) {
            setVirtualElement(undefined);
            return;
        }
        let mouseevent;
        if (!(event instanceof MouseEvent)) {
            mouseevent = event.nativeEvent;
        } else {
            mouseevent = event;
        }
        if (!(mouseevent instanceof MouseEvent) && process.env.NODE_ENV !== 'production') {
            // eslint-disable-next-line no-console
            console.error('usePositioningMouseTarget should only be used with MouseEvent');
        }
        const contextTarget = (0, _createVirtualElementFromClick.createVirtualElementFromClick)(mouseevent);
        setVirtualElement(contextTarget);
    };
    return [
        virtualElement,
        setVirtualMouseTarget
    ];
};
