"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "shift", {
    enumerable: true,
    get: function() {
        return shift;
    }
});
const _dom = require("@floating-ui/dom");
const _index = require("../utils/index");
function shift(options) {
    const { hasScrollableElement, shiftToCoverTarget, disableTether, overflowBoundary, container, overflowBoundaryPadding, isRtl } = options;
    return (0, _dom.shift)({
        ...hasScrollableElement && {
            boundary: 'clippingAncestors'
        },
        ...shiftToCoverTarget && {
            crossAxis: true,
            limiter: (0, _dom.limitShift)({
                crossAxis: true,
                mainAxis: false
            })
        },
        ...disableTether && {
            crossAxis: disableTether === 'all',
            limiter: (0, _dom.limitShift)({
                crossAxis: disableTether !== 'all',
                mainAxis: false
            })
        },
        ...overflowBoundaryPadding && {
            padding: (0, _index.toFloatingUIPadding)(overflowBoundaryPadding, isRtl)
        },
        ...overflowBoundary && {
            altBoundary: true,
            boundary: (0, _index.getBoundary)(container, overflowBoundary)
        }
    });
}
