"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    maxSize: function() {
        return maxSize;
    },
    resetMaxSize: function() {
        return resetMaxSize;
    }
});
const _dom = require("@floating-ui/dom");
const _getBoundary = require("../utils/getBoundary");
const _utils = require("../utils");
const resetMaxSize = (autoSize)=>({
        name: 'resetMaxSize',
        fn ({ middlewareData, elements }) {
            var _middlewareData_resetMaxSize;
            if ((_middlewareData_resetMaxSize = middlewareData.resetMaxSize) === null || _middlewareData_resetMaxSize === void 0 ? void 0 : _middlewareData_resetMaxSize.maxSizeAlreadyReset) {
                return {};
            }
            const { applyMaxWidth, applyMaxHeight } = autoSize;
            if (applyMaxWidth) {
                elements.floating.style.removeProperty('box-sizing');
                elements.floating.style.removeProperty('max-width');
                elements.floating.style.removeProperty('width');
            }
            if (applyMaxHeight) {
                elements.floating.style.removeProperty('box-sizing');
                elements.floating.style.removeProperty('max-height');
                elements.floating.style.removeProperty('height');
            }
            return {
                data: {
                    maxSizeAlreadyReset: true
                },
                reset: {
                    rects: true
                }
            };
        }
    });
function maxSize(autoSize, options) {
    const { container, overflowBoundary, overflowBoundaryPadding, isRtl } = options;
    return (0, _dom.size)({
        ...overflowBoundaryPadding && {
            padding: (0, _utils.toFloatingUIPadding)(overflowBoundaryPadding, isRtl)
        },
        ...overflowBoundary && {
            altBoundary: true,
            boundary: (0, _getBoundary.getBoundary)(container, overflowBoundary)
        },
        apply ({ availableHeight, availableWidth, elements, rects }) {
            const applyMaxSizeStyles = (apply, dimension, availableSize)=>{
                if (!apply) {
                    return;
                }
                elements.floating.style.setProperty('box-sizing', 'border-box');
                elements.floating.style.setProperty(`max-${dimension}`, `${availableSize}px`);
                if (rects.floating[dimension] > availableSize) {
                    elements.floating.style.setProperty(dimension, `${availableSize}px`);
                    const axis = dimension === 'width' ? 'x' : 'y';
                    if (!elements.floating.style.getPropertyValue(`overflow-${axis}`)) {
                        elements.floating.style.setProperty(`overflow-${axis}`, 'auto');
                    }
                }
            };
            const { applyMaxWidth, applyMaxHeight } = autoSize;
            applyMaxSizeStyles(applyMaxWidth, 'width', availableWidth);
            applyMaxSizeStyles(applyMaxHeight, 'height', availableHeight);
        }
    });
}
