"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    matchTargetSize: function() {
        return matchTargetSize;
    },
    matchTargetSizeCssVar: function() {
        return matchTargetSizeCssVar;
    }
});
const matchTargetSizeCssVar = '--fui-match-target-size';
function matchTargetSize() {
    return {
        name: 'matchTargetSize',
        fn: async (middlewareArguments)=>{
            const { rects: { reference: referenceRect, floating: floatingRect }, elements: { floating: floatingElement }, middlewareData: { matchTargetSize: { matchTargetSizeAttempt = false } = {} } } = middlewareArguments;
            if (referenceRect.width === floatingRect.width || matchTargetSizeAttempt) {
                return {};
            }
            const { width } = referenceRect;
            floatingElement.style.setProperty(matchTargetSizeCssVar, `${width}px`);
            if (!floatingElement.style.width) {
                floatingElement.style.width = `var(${matchTargetSizeCssVar})`;
            }
            return {
                data: {
                    matchTargetSizeAttempt: true
                },
                reset: {
                    rects: true
                }
            };
        }
    };
}
