"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "intersecting", {
    enumerable: true,
    get: function() {
        return intersecting;
    }
});
const _dom = require("@floating-ui/dom");
function intersecting() {
    return {
        name: 'intersectionObserver',
        fn: async (middlewareArguments)=>{
            const floatingRect = middlewareArguments.rects.floating;
            const altOverflow = await (0, _dom.detectOverflow)(middlewareArguments, {
                altBoundary: true
            });
            const isIntersectingTop = altOverflow.top < floatingRect.height && altOverflow.top > 0;
            const isIntersectingBottom = altOverflow.bottom < floatingRect.height && altOverflow.bottom > 0;
            const isIntersecting = isIntersectingTop || isIntersectingBottom;
            return {
                data: {
                    intersecting: isIntersecting
                }
            };
        }
    };
}
