"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "flip", {
    enumerable: true,
    get: function() {
        return flip;
    }
});
const _dom = require("@floating-ui/dom");
const _index = require("../utils/index");
function flip(options) {
    const { hasScrollableElement, flipBoundary, container, fallbackPositions = [], isRtl } = options;
    const fallbackPlacements = fallbackPositions.reduce((acc, shorthand)=>{
        const { position, align } = (0, _index.resolvePositioningShorthand)(shorthand);
        const placement = (0, _index.toFloatingUIPlacement)(align, position, isRtl);
        if (placement) {
            acc.push(placement);
        }
        return acc;
    }, []);
    return (0, _dom.flip)({
        ...hasScrollableElement && {
            boundary: 'clippingAncestors'
        },
        ...flipBoundary && {
            altBoundary: true,
            boundary: (0, _index.getBoundary)(container, flipBoundary)
        },
        fallbackStrategy: 'bestFit',
        ...fallbackPlacements.length && {
            fallbackPlacements
        }
    });
}
