"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "coverTarget", {
    enumerable: true,
    get: function() {
        return coverTarget;
    }
});
const _index = require("../utils/index");
function coverTarget() {
    return {
        name: 'coverTarget',
        fn: (middlewareArguments)=>{
            const { placement, rects, x, y } = middlewareArguments;
            const basePlacement = (0, _index.parseFloatingUIPlacement)(placement).side;
            const newCoords = {
                x,
                y
            };
            switch(basePlacement){
                case 'bottom':
                    newCoords.y -= rects.reference.height;
                    break;
                case 'top':
                    newCoords.y += rects.reference.height;
                    break;
                case 'left':
                    newCoords.x += rects.reference.width;
                    break;
                case 'right':
                    newCoords.x -= rects.reference.width;
                    break;
            }
            return newCoords;
        }
    };
}
