'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useSafeZoneArea", {
    enumerable: true,
    get: function() {
        return useSafeZoneArea;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _reactutilities = require("@fluentui/react-utilities");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _createSafeZoneAreaStateStore = require("./createSafeZoneAreaStateStore");
const _SafeZoneArea = require("./SafeZoneArea");
/**
 * Time in milliseconds after which the safe zone area will be cleared if no mouse movement is detected.
 *
 * Only affects the target element, not the safe zone area itself.
 */ const MOUSE_MOVE_TARGET_POLLING_TIMEOUT = 2000;
function useSafeZoneArea({ debug = false, disabled = false, onSafeZoneEnter, onSafeZoneMove, onSafeZoneLeave, onSafeZoneTimeout, timeout = 1500 } = {}) {
    const [stateStore] = _react.useState(_createSafeZoneAreaStateStore.createSafeZoneAreaStateStore);
    const safeZoneAreaRef = _react.useRef(null);
    const containerRef = _react.useRef(null);
    const targetRef = _react.useRef(null);
    const [setSafeZoneCloseTimeout, clearSafeZoneCloseTimeout] = (0, _reactutilities.useTimeout)();
    const [requestUpdateFrame, clearUpdateFrame] = (0, _reactutilities.useAnimationFrame)();
    const mouseCoordinatesRef = _react.useRef({
        x: 0,
        y: 0
    });
    const containerListenerRef = _react.useMemo(()=>{
        if (disabled) {
            return ()=>{
            // do nothing
            };
        }
        let containerEl = null;
        function onContainerMouseEnter() {
            clearSafeZoneCloseTimeout();
            stateStore.toggleActive(false);
        }
        return (el)=>{
            if (el === null) {
                containerEl === null || containerEl === void 0 ? void 0 : containerEl.removeEventListener('mouseenter', onContainerMouseEnter);
            }
            containerEl = el;
            el === null || el === void 0 ? void 0 : el.addEventListener('mouseenter', onContainerMouseEnter);
        };
    }, [
        clearSafeZoneCloseTimeout,
        disabled,
        stateStore
    ]);
    const targetListenerRef = _react.useMemo(()=>{
        if (disabled) {
            return ()=>{
            // do nothing
            };
        }
        let targetEl = null;
        function onTargetMouseMove(e) {
            mouseCoordinatesRef.current = {
                x: e.clientX,
                y: e.clientY
            };
            if (!stateStore.isActive()) {
                stateStore.toggleActive(true);
            }
            setSafeZoneCloseTimeout(()=>{
                stateStore.toggleActive(false);
            }, MOUSE_MOVE_TARGET_POLLING_TIMEOUT);
        }
        return (el)=>{
            if (el === null) {
                clearUpdateFrame();
                clearSafeZoneCloseTimeout();
                targetEl === null || targetEl === void 0 ? void 0 : targetEl.removeEventListener('mousemove', onTargetMouseMove);
            }
            targetEl = el;
            el === null || el === void 0 ? void 0 : el.addEventListener('mousemove', onTargetMouseMove);
        };
    }, [
        clearUpdateFrame,
        clearSafeZoneCloseTimeout,
        disabled,
        stateStore,
        setSafeZoneCloseTimeout
    ]);
    const onSvgMouseEnter = (0, _reactutilities.useEventCallback)((e)=>{
        onSafeZoneEnter === null || onSafeZoneEnter === void 0 ? void 0 : onSafeZoneEnter(e);
        setSafeZoneCloseTimeout(()=>{
            stateStore.toggleActive(false);
            onSafeZoneTimeout === null || onSafeZoneTimeout === void 0 ? void 0 : onSafeZoneTimeout();
        }, timeout);
    });
    const onSvgMouseMove = (0, _reactutilities.useEventCallback)((e)=>{
        setSafeZoneCloseTimeout(()=>{
            stateStore.toggleActive(false);
            onSafeZoneTimeout === null || onSafeZoneTimeout === void 0 ? void 0 : onSafeZoneTimeout();
        }, timeout);
        onSafeZoneMove === null || onSafeZoneMove === void 0 ? void 0 : onSafeZoneMove(e);
    });
    const onSvgMouseLeave = (0, _reactutilities.useEventCallback)((e)=>{
        onSafeZoneLeave === null || onSafeZoneLeave === void 0 ? void 0 : onSafeZoneLeave(e);
    });
    _react.useEffect(()=>{
        return stateStore.subscribe((isActive)=>{
            if (isActive) {
                function updateSVGs() {
                    const containerEl = containerRef.current;
                    const targetEl = targetRef.current;
                    if (containerEl && targetEl) {
                        var _safeZoneAreaRef_current;
                        (_safeZoneAreaRef_current = safeZoneAreaRef.current) === null || _safeZoneAreaRef_current === void 0 ? void 0 : _safeZoneAreaRef_current.updateSVG({
                            containerRect: containerEl.getBoundingClientRect(),
                            mouseCoordinates: [
                                mouseCoordinatesRef.current.x,
                                mouseCoordinatesRef.current.y
                            ],
                            targetRect: targetEl.getBoundingClientRect()
                        });
                    }
                    requestUpdateFrame(updateSVGs);
                }
                updateSVGs();
                return;
            }
            clearUpdateFrame();
        });
    }, [
        clearUpdateFrame,
        requestUpdateFrame,
        stateStore
    ]);
    return {
        containerRef: (0, _reactutilities.useMergedRefs)(containerRef, containerListenerRef),
        targetRef: (0, _reactutilities.useMergedRefs)(targetRef, targetListenerRef),
        elementToRender: _react.useMemo(()=>disabled ? null : /*#__PURE__*/ _react.createElement(_SafeZoneArea.SafeZoneArea, {
                debug: debug,
                onMouseEnter: onSvgMouseEnter,
                onMouseMove: onSvgMouseMove,
                onMouseLeave: onSvgMouseLeave,
                imperativeRef: safeZoneAreaRef,
                stateStore: stateStore
            }), [
            disabled,
            debug,
            onSvgMouseEnter,
            onSvgMouseMove,
            onSvgMouseLeave,
            stateStore
        ])
    };
}
