'use client';

import { __styles, mergeClasses } from '@griffel/react';
import { createArrowHeightStyles, createArrowStyles, createSlideStyles } from '@fluentui/react-positioning';
import { tokens, typographyStyles } from '@fluentui/react-theme';
export const popoverSurfaceClassNames = {
  root: 'fui-PopoverSurface'
};
export const arrowHeights = {
  small: 6,
  medium: 8,
  large: 8
};
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  root: {
    sj55zd: "f19n0e5",
    De3pzq: "fxugw4r",
    Beyfa6y: 0,
    Bbmb7ep: 0,
    Btl43ni: 0,
    B7oj6ja: 0,
    Dimara: "ft85np5",
    Bgfg5da: 0,
    B9xav0g: 0,
    oivjwe: 0,
    Bn0qgzm: 0,
    B4g9neb: 0,
    zhjwy3: 0,
    wvpqe5: 0,
    ibv6hh: 0,
    u1mtju: 0,
    h3c5rm: 0,
    vrafjx: 0,
    Bekrc4i: 0,
    i8vvqc: 0,
    g2u3we: 0,
    icvyot: 0,
    B4j52fo: 0,
    irswps: "f9ggezi",
    Bahqtrf: "fk6fouc",
    Be2twd7: "fkhj508",
    Bhrd7zp: "figsok6",
    Bg96gwp: "f1i3iumi",
    B93otf3: "f18k4bn6",
    vin17d: "fo1kyvf",
    Ezkn3b: "fetxo7e",
    nyiy2g: "f8x1vz1",
    swvrvq: "f8g0anz",
    Bkovbt3: "fezwn9i",
    hgjdhn: "fz5efge",
    fsy9dk: "f1ydixl4",
    B3ogreh: "f8dgqj5",
    jv49x5: "fnyfnr8",
    Bk7o48c: "fgw77r4",
    Bv12yb3: "f1noc5he",
    z0t1cu: "fi19xcv",
    Bks05zx: "f1mxk9aa",
    Bvtglag: "ffzg62k",
    Bhu2qc9: "fymb6k8"
  },
  inline: {
    Bj3rh1h: "f19g0ac"
  },
  inverted: {
    De3pzq: "fg3r6xk",
    sj55zd: "fonrgv7"
  },
  brand: {
    De3pzq: "ffp7eso",
    sj55zd: "f1phragk"
  },
  smallPadding: {
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f1sy4kr4"
  },
  mediumPadding: {
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "f4zyqsv"
  },
  largePadding: {
    Byoj8tv: 0,
    uwmqm3: 0,
    z189sj: 0,
    z8tnut: 0,
    B0ocmuz: "fop8ug2"
  },
  smallArrow: {
    rhnwrx: "f1s3jn22",
    Bdy53xb: "fv40uqz"
  },
  mediumLargeArrow: {
    rhnwrx: "f1f72gjr",
    Bdy53xb: "f69yoe5"
  },
  arrow: {
    B7ck84d: "f1ewtqcl",
    qhf8xq: "f1euv43f",
    Bj3rh1h: "f1bsuimh",
    De3pzq: "f1u2r49w",
    B2eet1l: "fqhgnl",
    Beyfa6y: "f17bz04i",
    Bz10aip: "f36o3x3",
    Bqenvij: "fzofk8q",
    a9b677: "f1wbx1ie",
    Ftih45: "f1wl9k8s",
    Br0sdwz: "f1aocrix",
    cmx5o7: "f1ljr5q2",
    susq4k: 0,
    Biibvgv: 0,
    Bicfajf: 0,
    qehafq: 0,
    Brs5u8j: "f155f1qt",
    Ccq8qp: "f9mhzq7",
    Baz25je: "fr6rhvx",
    Bcgcnre: 0,
    Bqjgrrk: 0,
    qa3bma: 0,
    y0oebl: 0,
    Biqmznv: 0,
    Bm6vgfq: 0,
    Bbv0w2i: 0,
    uvfttm: 0,
    eqrjj: 0,
    Bk5zm6e: 0,
    m598lv: 0,
    B4f6apu: 0,
    ydt019: 0,
    Bq4z7u6: 0,
    Bdkvgpv: 0,
    B0qfbqy: 0,
    kj8mxx: "f1kc0wz4",
    r59vdv: "fgq90dz",
    Bkw5xw4: "fq0y47f",
    hl6cv3: "f1pwrbz6",
    aea9ga: "f1hxxcvm",
    yayu3t: "fw8rgyo",
    Bhsv975: "f1wnzycx",
    rhl9o9: "f1730wal",
    B7gxrvb: "f1fy4ixr",
    B6q6orb: "fobkauc",
    B0lu1f8: "f16bqv1l"
  }
}, {
  d: [".f19n0e5{color:var(--colorNeutralForeground1);}", ".fxugw4r{background-color:var(--colorNeutralBackground1);}", [".ft85np5{border-radius:var(--borderRadiusMedium);}", {
    p: -1
  }], [".f9ggezi{border:1px solid var(--colorTransparentStroke);}", {
    p: -2
  }], ".fk6fouc{font-family:var(--fontFamilyBase);}", ".fkhj508{font-size:var(--fontSizeBase300);}", ".figsok6{font-weight:var(--fontWeightRegular);}", ".f1i3iumi{line-height:var(--lineHeightBase300);}", ".f18k4bn6{animation-composition:accumulate;}", ".fo1kyvf{animation-duration:var(--durationSlower);}", ".fetxo7e{animation-timing-function:var(--curveDecelerateMid);}", ".f8x1vz1{--fui-positioning-slide-distance-x:0px;}", ".f8g0anz{--fui-positioning-slide-distance-y:10px;}", ".fezwn9i[data-popper-placement^=right]{--fui-positioning-slide-distance-x:-10px;}", ".fz5efge[data-popper-placement^=right]{--fui-positioning-slide-distance-y:0px;}", ".f1ydixl4[data-popper-placement^=bottom]{--fui-positioning-slide-distance-x:0px;}", ".f8dgqj5[data-popper-placement^=bottom]{--fui-positioning-slide-distance-y:-10px;}", ".fnyfnr8[data-popper-placement^=left]{--fui-positioning-slide-distance-x:10px;}", ".fgw77r4[data-popper-placement^=left]{--fui-positioning-slide-distance-y:0px;}", ".f1noc5he{animation-name:f1m0q9mo,f79suad;}", ".fymb6k8{filter:drop-shadow(0 0 2px var(--colorNeutralShadowAmbient)) drop-shadow(0 8px 16px var(--colorNeutralShadowKey));}", ".f19g0ac{z-index:1;}", ".fg3r6xk{background-color:var(--colorNeutralBackgroundStatic);}", ".fonrgv7{color:var(--colorNeutralForegroundStaticInverted);}", ".ffp7eso{background-color:var(--colorBrandBackground);}", ".f1phragk{color:var(--colorNeutralForegroundOnBrand);}", [".f1sy4kr4{padding:12px;}", {
    p: -1
  }], [".f4zyqsv{padding:16px;}", {
    p: -1
  }], [".fop8ug2{padding:20px;}", {
    p: -1
  }], ".f1s3jn22{--fui-positioning-arrow-height:8.484px;}", ".fv40uqz{--fui-positioning-arrow-offset:-4.242px;}", ".f1f72gjr{--fui-positioning-arrow-height:11.312px;}", ".f69yoe5{--fui-positioning-arrow-offset:-5.656px;}", ".f1ewtqcl{box-sizing:border-box;}", ".f1euv43f{position:absolute;}", ".f1bsuimh{z-index:-1;}", ".f1u2r49w{background-color:inherit;}", ".fqhgnl{background-clip:content-box;}", ".f17bz04i{border-bottom-left-radius:var(--borderRadiusSmall);}", ".f36o3x3{transform:rotate(var(--fui-positioning-arrow-angle));}", ".fzofk8q{height:var(--fui-positioning-arrow-height);}", ".f1wbx1ie{width:var(--fui-positioning-arrow-height);}", ".f1wl9k8s::before{content:\"\";}", ".f1aocrix::before{display:block;}", ".f1ljr5q2::before{background-color:inherit;}", [".f155f1qt::before{margin:-1px;}", {
    p: -1
  }], ".f9mhzq7::before{width:100%;}", ".fr6rhvx::before{height:100%;}", [".f1kc0wz4::before{border:1px solid var(--colorTransparentStroke);}", {
    p: -2
  }], ".fgq90dz::before{border-bottom-left-radius:var(--borderRadiusSmall);}", ".fq0y47f::before{clip-path:polygon(0% 0%, 100% 100%, 0% 100%);}", "[data-popper-placement^=\"top\"] .f1pwrbz6{bottom:var(--fui-positioning-arrow-offset);}", "[data-popper-placement^=\"top\"] .f1hxxcvm{--fui-positioning-arrow-angle:-45deg;}", "[data-popper-placement^=\"right\"] .fw8rgyo{left:var(--fui-positioning-arrow-offset);}", "[data-popper-placement^=\"right\"] .f1wnzycx{--fui-positioning-arrow-angle:45deg;}", "[data-popper-placement^=\"bottom\"] .f1730wal{top:var(--fui-positioning-arrow-offset);}", "[data-popper-placement^=\"bottom\"] .f1fy4ixr{--fui-positioning-arrow-angle:135deg;}", "[data-popper-placement^=\"left\"] .fobkauc{right:var(--fui-positioning-arrow-offset);}", "[data-popper-placement^=\"left\"] .f16bqv1l{--fui-positioning-arrow-angle:225deg;}"],
  k: ["@keyframes f1m0q9mo{from{opacity:-1;}to{opacity:0;}}", "@keyframes f79suad{from{transform:translate(var(--fui-positioning-slide-distance-x), var(--fui-positioning-slide-distance-y));}}"],
  m: [["@media (prefers-reduced-motion){.fi19xcv[data-popper-placement]{animation-duration:1ms;}}", {
    m: "(prefers-reduced-motion)"
  }], ["@media (prefers-reduced-motion){.f1mxk9aa[data-popper-placement]{animation-name:f1m0q9mo;}}", {
    m: "(prefers-reduced-motion)"
  }]],
  t: ["@supports not (animation-composition: accumulate){.ffzg62k[data-popper-placement]{animation-name:f1m0q9mo;}}"]
});
/**
 * Apply styling to the PopoverSurface slots based on the state
 */
export const usePopoverSurfaceStyles_unstable = state => {
  'use no memo';

  const styles = useStyles();
  state.root.className = mergeClasses(popoverSurfaceClassNames.root, styles.root, state.inline && styles.inline, state.size === 'small' && styles.smallPadding, state.size === 'medium' && styles.mediumPadding, state.size === 'large' && styles.largePadding, state.appearance === 'inverted' && styles.inverted, state.appearance === 'brand' && styles.brand, state.root.className);
  state.arrowClassName = mergeClasses(styles.arrow, state.size === 'small' ? styles.smallArrow : styles.mediumLargeArrow);
  return state;
};