'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "usePopoverTrigger_unstable", {
    enumerable: true,
    get: function() {
        return usePopoverTrigger_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const _popoverContext = require("../../popoverContext");
const _reactaria = require("@fluentui/react-aria");
const _keyboardkeys = require("@fluentui/keyboard-keys");
const usePopoverTrigger_unstable = (props)=>{
    const { children, disableButtonEnhancement = false } = props;
    const child = (0, _reactutilities.getTriggerChild)(children);
    const open = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.open);
    const setOpen = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.setOpen);
    const toggleOpen = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.toggleOpen);
    const triggerRef = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.triggerRef);
    const openOnHover = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.openOnHover);
    const openOnContext = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.openOnContext);
    const { triggerAttributes } = (0, _reacttabster.useModalAttributes)();
    const onContextMenu = (e)=>{
        if (openOnContext) {
            e.preventDefault();
            setOpen(e, true);
        }
    };
    const onClick = (e)=>{
        if (!openOnContext) {
            toggleOpen(e);
        }
    };
    const onKeyDown = (e)=>{
        if (e.key === _keyboardkeys.Escape && open && !e.isDefaultPrevented()) {
            setOpen(e, false);
            // stop propagation to avoid conflicting with other elements that listen for `Escape`
            // e,g: Dialog, Popover, Menu and Tooltip
            e.preventDefault();
        }
    };
    const onMouseEnter = (e)=>{
        if (openOnHover) {
            setOpen(e, true);
        }
    };
    const onMouseLeave = (e)=>{
        if (openOnHover) {
            setOpen(e, false);
        }
    };
    const contextMenuProps = {
        ...triggerAttributes,
        'aria-expanded': `${open}`,
        ...child === null || child === void 0 ? void 0 : child.props,
        onMouseEnter: (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(child === null || child === void 0 ? void 0 : child.props.onMouseEnter, onMouseEnter)),
        onMouseLeave: (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(child === null || child === void 0 ? void 0 : child.props.onMouseLeave, onMouseLeave)),
        onContextMenu: (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(child === null || child === void 0 ? void 0 : child.props.onContextMenu, onContextMenu)),
        ref: (0, _reactutilities.useMergedRefs)(triggerRef, (0, _reactutilities.getReactElementRef)(child))
    };
    const triggerChildProps = {
        ...contextMenuProps,
        onClick: (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(child === null || child === void 0 ? void 0 : child.props.onClick, onClick)),
        onKeyDown: (0, _reactutilities.useEventCallback)((0, _reactutilities.mergeCallbacks)(child === null || child === void 0 ? void 0 : child.props.onKeyDown, onKeyDown))
    };
    const ariaButtonTriggerChildProps = (0, _reactaria.useARIAButtonProps)((child === null || child === void 0 ? void 0 : child.type) === 'button' || (child === null || child === void 0 ? void 0 : child.type) === 'a' ? child.type : 'div', triggerChildProps);
    return {
        children: (0, _reactutilities.applyTriggerPropsToChildren)(props.children, (0, _reactaria.useARIAButtonProps)((child === null || child === void 0 ? void 0 : child.type) === 'button' || (child === null || child === void 0 ? void 0 : child.type) === 'a' ? child.type : 'div', openOnContext ? contextMenuProps : disableButtonEnhancement ? triggerChildProps : ariaButtonTriggerChildProps))
    };
};
