'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
function _export(target, all) {
    for(var name in all)Object.defineProperty(target, name, {
        enumerable: true,
        get: all[name]
    });
}
_export(exports, {
    arrowHeights: function() {
        return arrowHeights;
    },
    popoverSurfaceClassNames: function() {
        return popoverSurfaceClassNames;
    },
    usePopoverSurfaceStyles_unstable: function() {
        return usePopoverSurfaceStyles_unstable;
    }
});
const _react = require("@griffel/react");
const _reactpositioning = require("@fluentui/react-positioning");
const _reacttheme = require("@fluentui/react-theme");
const popoverSurfaceClassNames = {
    root: 'fui-PopoverSurface'
};
const arrowHeights = {
    small: 6,
    medium: 8,
    large: 8
};
/**
 * Styles for the root slot
 */ const useStyles = (0, _react.makeStyles)({
    root: {
        color: _reacttheme.tokens.colorNeutralForeground1,
        backgroundColor: _reacttheme.tokens.colorNeutralBackground1,
        borderRadius: _reacttheme.tokens.borderRadiusMedium,
        border: `1px solid ${_reacttheme.tokens.colorTransparentStroke}`,
        ..._reacttheme.typographyStyles.body1,
        ...(0, _reactpositioning.createSlideStyles)(10),
        // TODO need to add versions of tokens.alias.shadow.shadow16, etc. that work with filter
        filter: `drop-shadow(0 0 2px ${_reacttheme.tokens.colorNeutralShadowAmbient}) ` + `drop-shadow(0 8px 16px ${_reacttheme.tokens.colorNeutralShadowKey})`
    },
    inline: {
        // When rendering inline, the PopoverSurface will be rendered under relatively positioned elements such as Input.
        // This is due to the surface being positioned as absolute, therefore zIndex: 1 ensures that won't happen.
        zIndex: 1
    },
    inverted: {
        backgroundColor: _reacttheme.tokens.colorNeutralBackgroundStatic,
        color: _reacttheme.tokens.colorNeutralForegroundStaticInverted
    },
    brand: {
        backgroundColor: _reacttheme.tokens.colorBrandBackground,
        color: _reacttheme.tokens.colorNeutralForegroundOnBrand
    },
    smallPadding: {
        padding: '12px'
    },
    mediumPadding: {
        padding: '16px'
    },
    largePadding: {
        padding: '20px'
    },
    smallArrow: (0, _reactpositioning.createArrowHeightStyles)(arrowHeights.small),
    mediumLargeArrow: (0, _reactpositioning.createArrowHeightStyles)(arrowHeights.medium),
    arrow: (0, _reactpositioning.createArrowStyles)({
        arrowHeight: undefined
    })
});
const usePopoverSurfaceStyles_unstable = (state)=>{
    'use no memo';
    const styles = useStyles();
    state.root.className = (0, _react.mergeClasses)(popoverSurfaceClassNames.root, styles.root, state.inline && styles.inline, state.size === 'small' && styles.smallPadding, state.size === 'medium' && styles.mediumPadding, state.size === 'large' && styles.largePadding, state.appearance === 'inverted' && styles.inverted, state.appearance === 'brand' && styles.brand, state.root.className);
    state.arrowClassName = (0, _react.mergeClasses)(styles.arrow, state.size === 'small' ? styles.smallArrow : styles.mediumLargeArrow);
    return state;
};
