'use client';
"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "usePopoverSurface_unstable", {
    enumerable: true,
    get: function() {
        return usePopoverSurface_unstable;
    }
});
const _interop_require_wildcard = require("@swc/helpers/_/_interop_require_wildcard");
const _react = /*#__PURE__*/ _interop_require_wildcard._(require("react"));
const _reactutilities = require("@fluentui/react-utilities");
const _reacttabster = require("@fluentui/react-tabster");
const _popoverContext = require("../../popoverContext");
const usePopoverSurface_unstable = (props, ref)=>{
    const contentRef = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.contentRef);
    const openOnHover = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.openOnHover);
    const setOpen = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.setOpen);
    const mountNode = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.mountNode);
    const arrowRef = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.arrowRef);
    const size = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.size);
    const withArrow = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.withArrow);
    const appearance = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.appearance);
    const trapFocus = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.trapFocus);
    const inertTrapFocus = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.inertTrapFocus);
    const inline = (0, _popoverContext.usePopoverContext_unstable)((context)=>context.inline);
    const { modalAttributes } = (0, _reacttabster.useModalAttributes)({
        trapFocus,
        legacyTrapFocus: !inertTrapFocus,
        alwaysFocusable: !trapFocus
    });
    const state = {
        inline,
        appearance,
        withArrow,
        size,
        arrowRef,
        mountNode,
        components: {
            root: 'div'
        },
        root: _reactutilities.slot.always((0, _reactutilities.getIntrinsicElementProps)('div', {
            // FIXME:
            // `contentRef` is wrongly assigned to be `HTMLElement` instead of `HTMLDivElement`
            // but since it would be a breaking change to fix it, we are casting ref to it's proper type
            ref: (0, _reactutilities.useMergedRefs)(ref, contentRef),
            role: trapFocus ? 'dialog' : 'group',
            'aria-modal': trapFocus ? true : undefined,
            ...modalAttributes,
            ...props
        }), {
            elementType: 'div'
        })
    };
    const { onMouseEnter: onMouseEnterOriginal, onMouseLeave: onMouseLeaveOriginal, onKeyDown: onKeyDownOriginal } = state.root;
    state.root.onMouseEnter = (e)=>{
        if (openOnHover) {
            setOpen(e, true);
        }
        onMouseEnterOriginal === null || onMouseEnterOriginal === void 0 ? void 0 : onMouseEnterOriginal(e);
    };
    state.root.onMouseLeave = (e)=>{
        if (openOnHover) {
            setOpen(e, false);
        }
        onMouseLeaveOriginal === null || onMouseLeaveOriginal === void 0 ? void 0 : onMouseLeaveOriginal(e);
    };
    state.root.onKeyDown = (e)=>{
        var _contentRef_current;
        // only close if the event happened inside the current popover
        // If using a stack of inline popovers, the user should call `stopPropagation` to avoid dismissing the entire stack
        if (e.key === 'Escape' && ((_contentRef_current = contentRef.current) === null || _contentRef_current === void 0 ? void 0 : _contentRef_current.contains(e.target))) {
            e.preventDefault();
            setOpen(e, false);
        }
        onKeyDownOriginal === null || onKeyDownOriginal === void 0 ? void 0 : onKeyDownOriginal(e);
    };
    return state;
};
