import { ARIAButtonResultProps } from '@fluentui/react-aria';
import { ARIAButtonType } from '@fluentui/react-aria';
import type { ComponentProps } from '@fluentui/react-utilities';
import type { ComponentState } from '@fluentui/react-utilities';
import type { ContextSelector } from '@fluentui/react-context-selector';
import { FC } from 'react';
import type { ForwardRefComponent } from '@fluentui/react-utilities';
import type { JSXElement } from '@fluentui/react-utilities';
import type { PortalProps } from '@fluentui/react-portal';
import type { PositioningShorthand } from '@fluentui/react-positioning';
import type { PositioningVirtualElement } from '@fluentui/react-positioning';
import { Provider } from 'react';
import { ProviderProps } from 'react';
import * as React_2 from 'react';
import type { SetVirtualMouseTarget } from '@fluentui/react-positioning';
import type { Slot } from '@fluentui/react-utilities';
import type { SlotClassNames } from '@fluentui/react-utilities';
import type { TriggerProps } from '@fluentui/react-utilities';

export declare const arrowHeights: Record<PopoverSize, number>;

/**
 * Data attached to open/close events
 */
export declare type OnOpenChangeData = {
    open: boolean;
};

/**
 * The supported events that will trigger open/close of the menu
 */
export declare type OpenPopoverEvents = MouseEvent | TouchEvent | React_2.FocusEvent<HTMLElement> | React_2.KeyboardEvent<HTMLElement> | React_2.MouseEvent<HTMLElement>;

/**
 * Wrapper component that manages state for a PopoverTrigger and a PopoverSurface components.
 */
export declare const Popover: React_2.FC<PopoverProps>;

/**
 * Context shared between Popover and its children components
 */
export declare type PopoverContextValue = Pick<PopoverState, 'open' | 'toggleOpen' | 'setOpen' | 'triggerRef' | 'contentRef' | 'openOnHover' | 'openOnContext' | 'mountNode' | 'withArrow' | 'arrowRef' | 'size' | 'appearance' | 'trapFocus' | 'inertTrapFocus' | 'inline'>;

/**
 * Popover Props
 */
export declare type PopoverProps = Pick<PortalProps, 'mountNode'> & {
    /**
     * A popover can appear styled with brand or inverted.
     * When not specified, the default style is used.
     */
    appearance?: 'brand' | 'inverted';
    /**
     * Can contain two children including `PopoverTrigger` and `PopoverSurface`.
     * Alternatively can only contain `PopoverSurface` if using a custom `target`.
     */
    children: [JSXElement, JSXElement] | JSXElement;
    /**
     * Close when scroll outside of it
     *
     * @default false
     */
    closeOnScroll?: boolean;
    /**
     * Used to set the initial open state of the Popover in uncontrolled mode
     *
     * @default false
     */
    defaultOpen?: boolean;
    /**
     * Popovers are rendered out of DOM order on `document.body` by default, use this to render the popover in DOM order
     *
     * @default false
     */
    inline?: boolean;
    /**
     * Sets the delay for closing popover on mouse leave
     */
    mouseLeaveDelay?: number;
    /**
     * Display an arrow pointing to the target.
     *
     * @default false
     */
    withArrow?: boolean;
    /**
     * Call back when the component requests to change value
     * The `open` value is used as a hint when directly controlling the component
     */
    onOpenChange?: (e: OpenPopoverEvents, data: OnOpenChangeData) => void;
    /**
     * Controls the opening of the Popover
     *
     * @default false
     */
    open?: boolean;
    /**
     * Flag to open the Popover as a context menu. Disables all other interactions
     *
     * @default false
     */
    openOnContext?: boolean;
    /**
     * Flag to open the Popover by hovering the trigger
     *
     * @default false
     */
    openOnHover?: boolean;
    /**
     * Flag to close the Popover when an iframe outside a PopoverSurface is focused
     *
     * @default true
     */
    closeOnIframeFocus?: boolean;
    /**
     * Configures the position of the Popover.
     * Explore [Positioning docs](?path=/docs/concepts-developer-positioning-components--docs) for more options.
     */
    positioning?: PositioningShorthand;
    /**
     * Determines popover padding and arrow size
     *
     * @default medium
     */
    size?: PopoverSize;
    /**
     * Should trap focus
     *
     * @default false
     */
    trapFocus?: boolean;
    /**
     * Must be used with the `trapFocus` prop
     * Enables older Fluent UI focus trap behavior where the user
     * cannot tab into the window outside of the document. This is now
     * non-standard behavior according to the [HTML dialog spec](https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement/showModal)
     * where the focus trap involves setting outside elements inert.
     *
     * @deprecated this behavior is default provided now, to opt-out of it in favor of standard behavior use the `inertTrapFocus` property
     */
    legacyTrapFocus?: boolean;
    /**
     * Enables standard behavior according to the [HTML dialog spec](https://developer.mozilla.org/en-US/docs/Web/API/HTMLDialogElement/showModal)
     * where the focus trap involves setting outside elements inert,
     * making navigation leak from the trapped area back to the browser toolbar and vice-versa.
     *
     * @default false
     */
    inertTrapFocus?: boolean;
    /**
     * By default Popover focuses the first focusable element in PopoverSurface on open.
     * Specify `disableAutoFocus` to prevent this behavior.
     *
     * @default false
     */
    unstable_disableAutoFocus?: boolean;
};

export declare const PopoverProvider: Provider<PopoverContextValue> & FC<ProviderProps<PopoverContextValue>>;

/**
 * Determines popover padding and arrow size
 */
export declare type PopoverSize = 'small' | 'medium' | 'large';

/**
 * Popover State
 */
export declare type PopoverState = Pick<PopoverProps, 'appearance' | 'mountNode' | 'onOpenChange' | 'openOnContext' | 'openOnHover' | 'trapFocus' | 'withArrow' | 'inertTrapFocus'> & Required<Pick<PopoverProps, 'inline' | 'open'>> & Pick<PopoverProps, 'children'> & {
    /**
     * Ref of the pointing arrow
     */
    arrowRef: React_2.MutableRefObject<HTMLDivElement | null>;
    /**
     * Ref of the PopoverSurface
     */
    contentRef: React_2.MutableRefObject<HTMLElement | null>;
    /**
     * Anchors the popper to the mouse click for context events
     */
    contextTarget: PositioningVirtualElement | undefined;
    popoverSurface: React_2.ReactElement | undefined;
    popoverTrigger: React_2.ReactElement | undefined;
    /**
     * A callback to set the target of the popper to the mouse click for context events
     */
    setContextTarget: SetVirtualMouseTarget;
    /**
     * Callback to open/close the Popover
     */
    setOpen: (e: OpenPopoverEvents, open: boolean) => void;
    size: NonNullable<PopoverProps['size']>;
    /**
     * Callback to toggle the open state of the Popover
     */
    toggleOpen: (e: OpenPopoverEvents) => void;
    /**
     * Ref of the PopoverTrigger
     */
    triggerRef: React_2.MutableRefObject<HTMLElement | null>;
};

/**
 * PopoverSurface component renders react children in a positioned box
 */
export declare const PopoverSurface: ForwardRefComponent<PopoverSurfaceProps>;

export declare const popoverSurfaceClassNames: SlotClassNames<PopoverSurfaceSlots>;

/**
 * PopoverSurface Props
 */
export declare type PopoverSurfaceProps = ComponentProps<PopoverSurfaceSlots>;

/**
 * Names of the slots in PopoverSurfaceProps
 */
export declare type PopoverSurfaceSlots = {
    root: Slot<'div'>;
};

/**
 * PopoverSurface State
 */
export declare type PopoverSurfaceState = ComponentState<PopoverSurfaceSlots> & Pick<PopoverContextValue, 'appearance' | 'arrowRef' | 'inline' | 'mountNode' | 'size' | 'withArrow'> & {
    /**
     * CSS class for the arrow element
     */
    arrowClassName?: string;
};

/**
 * Wraps a trigger element as an only child and adds the necessary event handling to open a popover.
 */
export declare const PopoverTrigger: React_2.FC<PopoverTriggerProps>;

/**
 * Props that are passed to the child of the DialogTrigger when cloned to ensure correct behaviour for the Dialog
 */
export declare type PopoverTriggerChildProps<Type extends ARIAButtonType = ARIAButtonType, Props = {}> = ARIAButtonResultProps<Type, Props & {
    'aria-expanded'?: 'true' | 'false';
    ref: React_2.Ref<unknown>;
    onMouseEnter: React_2.MouseEventHandler<HTMLButtonElement & HTMLAnchorElement & HTMLDivElement>;
    onMouseLeave: React_2.MouseEventHandler<HTMLButtonElement & HTMLAnchorElement & HTMLDivElement>;
    onContextMenu: React_2.MouseEventHandler<HTMLButtonElement & HTMLAnchorElement & HTMLDivElement>;
}>;

/**
 * PopoverTrigger Props
 */
export declare type PopoverTriggerProps = TriggerProps<PopoverTriggerChildProps> & {
    /**
     * Disables internal trigger mechanism that ensures a child provided will be a compliant ARIA button.
     * @default false
     */
    disableButtonEnhancement?: boolean;
};

/**
 * PopoverTrigger State
 */
export declare type PopoverTriggerState = {
    children: React_2.ReactElement | null;
};

/**
 * Render the final JSX of Popover
 */
export declare const renderPopover_unstable: (state: PopoverState) => JSXElement;

/**
 * Render the final JSX of PopoverSurface
 */
export declare const renderPopoverSurface_unstable: (state: PopoverSurfaceState) => JSXElement;

/**
 * Render the final JSX of PopoverTrigger
 */
export declare const renderPopoverTrigger_unstable: (state: PopoverTriggerState) => JSXElement | null;

/**
 * Create the state required to render Popover.
 *
 * The returned state can be modified with hooks such as usePopoverStyles,
 * before being passed to renderPopover_unstable.
 *
 * @param props - props from this instance of Popover
 */
export declare const usePopover_unstable: (props: PopoverProps) => PopoverState;

export declare const usePopoverContext_unstable: <T>(selector: ContextSelector<PopoverContextValue, T>) => T;

/**
 * Create the state required to render PopoverSurface.
 *
 * The returned state can be modified with hooks such as usePopoverSurfaceStyles_unstable,
 * before being passed to renderPopoverSurface_unstable.
 *
 * @param props - props from this instance of PopoverSurface
 * @param ref - reference to root HTMLDivElement of PopoverSurface
 */
export declare const usePopoverSurface_unstable: (props: PopoverSurfaceProps, ref: React_2.Ref<HTMLDivElement>) => PopoverSurfaceState;

/**
 * Apply styling to the PopoverSurface slots based on the state
 */
export declare const usePopoverSurfaceStyles_unstable: (state: PopoverSurfaceState) => PopoverSurfaceState;

/**
 * Create the state required to render PopoverTrigger.
 *
 * The returned state can be modified with hooks such as usePopoverTriggerStyles,
 * before being passed to renderPopoverTrigger_unstable.
 *
 * @param props - props from this instance of PopoverTrigger
 */
export declare const usePopoverTrigger_unstable: (props: PopoverTriggerProps) => PopoverTriggerState;

export { }
