'use client';

import { __resetStyles, __styles, mergeClasses } from '@griffel/react';
import { tokens, typographyStyles } from '@fluentui/react-theme';
export const personaClassNames = {
  root: 'fui-Persona',
  avatar: 'fui-Persona__avatar',
  presence: 'fui-Persona__presence',
  primaryText: 'fui-Persona__primaryText',
  secondaryText: 'fui-Persona__secondaryText',
  tertiaryText: 'fui-Persona__tertiaryText',
  quaternaryText: 'fui-Persona__quaternaryText'
};
const avatarSpacing = `--fui-Persona__avatar--spacing`;
const useRootClassName = /*#__PURE__*/__resetStyles("rlroi9i", null, [".rlroi9i{display:inline-grid;grid-auto-rows:max-content;grid-auto-flow:column;justify-items:start;grid-template-columns:max-content [middle] auto;}"]);
/**
 * Styles for the root slot
 */
const useStyles = /*#__PURE__*/__styles({
  beforeAfterCenter: {
    wkccdc: "f1iantul"
  },
  after: {},
  before: {
    B7hvi0a: "f1tll2w5",
    Budl1dq: "ffvkwdr"
  },
  below: {
    Bxotwcr: "f1nkeedh",
    B7hvi0a: "f1oiokrs",
    Budl1dq: "f1emgwh2"
  },
  media: {
    Ijaq50: "f1hek2iy"
  },
  mediaBeforeAfterCenter: {
    Ijaq50: "fa4dipu"
  },
  start: {
    qb2dma: "f9h729m"
  },
  center: {
    qb2dma: "f7nlbp4"
  },
  afterAlignToPrimary: {
    qb2dma: "f7nlbp4",
    Ijaq50: "f1rnkkuc",
    Bw0ie65: "f1warjpf"
  },
  beforeAlignToPrimary: {
    qb2dma: "f7nlbp4",
    Ijaq50: "f1rnkkuc",
    Br312pm: "fwu52yu"
  },
  secondLineSpacing: {
    B6of3ja: "f1ryq6si"
  },
  primary: {
    Ijaq50: "f1q3ipgb"
  },
  secondary: {
    Ijaq50: "f3drtdk"
  },
  tertiary: {
    Ijaq50: "fa1o6s1"
  },
  quaternary: {
    Ijaq50: "f1tuwaia"
  }
}, {
  d: [".f1iantul{grid-template-rows:1fr [primary] max-content [secondary] max-content [tertiary] max-content [quaternary] max-content 1fr;}", ".f1tll2w5{justify-items:end;}", ".ffvkwdr{grid-template-columns:auto [middle] max-content;}", ".f1nkeedh{grid-auto-flow:unset;}", ".f1oiokrs{justify-items:center;}", ".f1emgwh2{grid-template-columns:unset;}", ".f1hek2iy{grid-row-start:span 5;}", ".fa4dipu{grid-row-start:span 6;}", ".f9h729m{align-self:start;}", ".f7nlbp4{align-self:center;}", ".f1rnkkuc{grid-row-start:unset;}", ".f1warjpf{grid-column-end:middle;}", ".fwu52yu{grid-column-start:middle;}", ".f1ryq6si{margin-top:-2px;}", ".f1q3ipgb{grid-row-start:primary;}", ".f3drtdk{grid-row-start:secondary;}", ".fa1o6s1{grid-row-start:tertiary;}", ".f1tuwaia{grid-row-start:quaternary;}"]
});
const useAvatarSpacingStyles = /*#__PURE__*/__styles({
  "extra-small": {
    Bs1gm4r: "f1e48tse"
  },
  small: {
    Bs1gm4r: "f18q9vkd"
  },
  medium: {
    Bs1gm4r: "f18q9vkd"
  },
  large: {
    Bs1gm4r: "fx34bi6"
  },
  "extra-large": {
    Bs1gm4r: "fx34bi6"
  },
  huge: {
    Bs1gm4r: "f1o96qtm"
  },
  after: {
    t21cq0: ["f103ycu4", "f1tao51"]
  },
  below: {
    jrapky: "fbo7acy"
  },
  before: {
    Frg6f3: ["f1tao51", "f103ycu4"]
  }
}, {
  d: [".f1e48tse{--fui-Persona__avatar--spacing:var(--spacingHorizontalSNudge);}", ".f18q9vkd{--fui-Persona__avatar--spacing:var(--spacingHorizontalS);}", ".fx34bi6{--fui-Persona__avatar--spacing:var(--spacingHorizontalMNudge);}", ".f1o96qtm{--fui-Persona__avatar--spacing:var(--spacingHorizontalM);}", ".f103ycu4{margin-right:var(--fui-Persona__avatar--spacing);}", ".f1tao51{margin-left:var(--fui-Persona__avatar--spacing);}", ".fbo7acy{margin-bottom:var(--fui-Persona__avatar--spacing);}"]
});
const usePresenceSpacingStyles = /*#__PURE__*/__styles({
  small: {
    Bs1gm4r: "f1e48tse"
  }
}, {
  d: [".f1e48tse{--fui-Persona__avatar--spacing:var(--spacingHorizontalSNudge);}"]
});
/**
 * Apply styling to the Persona slots based on the state
 */
export const usePersonaStyles_unstable = state => {
  'use no memo';

  const {
    presenceOnly,
    size,
    textAlignment,
    textPosition
  } = state;
  const alignToPrimary = presenceOnly && textAlignment === 'start' && size !== 'extra-large' && size !== 'huge';
  const alignBeforeAfterCenter = textPosition !== 'below' && textAlignment === 'center';
  const {
    primaryTextClassName,
    optionalTextClassName
  } = useTextClassNames(state, alignToPrimary);
  const rootClassName = useRootClassName();
  const styles = useStyles();
  const avatarSpacingStyles = useAvatarSpacingStyles();
  const presenceSpacingStyles = {
    ...avatarSpacingStyles,
    ...usePresenceSpacingStyles()
  };
  state.root.className = mergeClasses(personaClassNames.root, rootClassName, alignBeforeAfterCenter && styles.beforeAfterCenter, styles[textPosition], state.root.className);
  if (state.avatar) {
    state.avatar.className = mergeClasses(personaClassNames.avatar, textPosition !== 'below' && styles.media, alignBeforeAfterCenter && styles.mediaBeforeAfterCenter, styles[textAlignment], avatarSpacingStyles[size], avatarSpacingStyles[textPosition], state.avatar.className);
  }
  if (state.presence) {
    state.presence.className = mergeClasses(personaClassNames.presence, textPosition !== 'below' && styles.media, alignBeforeAfterCenter && styles.mediaBeforeAfterCenter, styles[textAlignment], presenceSpacingStyles[size], presenceSpacingStyles[textPosition], textPosition === 'after' && alignToPrimary && styles.afterAlignToPrimary, textPosition === 'before' && alignToPrimary && styles.beforeAlignToPrimary, state.presence.className);
  }
  if (state.primaryText) {
    state.primaryText.className = mergeClasses(personaClassNames.primaryText, alignBeforeAfterCenter && styles.primary, primaryTextClassName, state.primaryText.className);
  }
  if (state.secondaryText) {
    state.secondaryText.className = mergeClasses(personaClassNames.secondaryText, alignBeforeAfterCenter && styles.secondary, optionalTextClassName, styles.secondLineSpacing, state.secondaryText.className);
  }
  if (state.tertiaryText) {
    state.tertiaryText.className = mergeClasses(personaClassNames.tertiaryText, alignBeforeAfterCenter && styles.tertiary, optionalTextClassName, state.tertiaryText.className);
  }
  if (state.quaternaryText) {
    state.quaternaryText.className = mergeClasses(personaClassNames.quaternaryText, alignBeforeAfterCenter && styles.quaternary, optionalTextClassName, state.quaternaryText.className);
  }
  return state;
};
const usePrimaryTextBaseClassName = /*#__PURE__*/__resetStyles("rvj41k9", null, [".rvj41k9{display:block;color:var(--colorNeutralForeground1);font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase300);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase300);}"]);
const useOptionalTextBaseClassName = /*#__PURE__*/__resetStyles("rp1pf9e", null, [".rp1pf9e{display:block;color:var(--colorNeutralForeground2);font-family:var(--fontFamilyBase);font-size:var(--fontSizeBase200);font-weight:var(--fontWeightRegular);line-height:var(--lineHeightBase200);}"]);
const useTextStyles = /*#__PURE__*/__styles({
  beforeAlignToPrimary: {
    Bw0ie65: "f1warjpf"
  },
  afterAlignToPrimary: {
    Br312pm: "fwu52yu"
  },
  body1: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fkhj508",
    Bhrd7zp: "figsok6",
    Bg96gwp: "f1i3iumi"
  },
  caption1: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fy9rknc",
    Bhrd7zp: "figsok6",
    Bg96gwp: "fwrc4pm"
  },
  subtitle2: {
    Bahqtrf: "fk6fouc",
    Be2twd7: "fod5ikn",
    Bhrd7zp: "fl43uef",
    Bg96gwp: "faaz57k"
  }
}, {
  d: [".f1warjpf{grid-column-end:middle;}", ".fwu52yu{grid-column-start:middle;}", ".fk6fouc{font-family:var(--fontFamilyBase);}", ".fkhj508{font-size:var(--fontSizeBase300);}", ".figsok6{font-weight:var(--fontWeightRegular);}", ".f1i3iumi{line-height:var(--lineHeightBase300);}", ".fy9rknc{font-size:var(--fontSizeBase200);}", ".fwrc4pm{line-height:var(--lineHeightBase200);}", ".fod5ikn{font-size:var(--fontSizeBase400);}", ".fl43uef{font-weight:var(--fontWeightSemibold);}", ".faaz57k{line-height:var(--lineHeightBase400);}"]
});
const useTextClassNames = (state, alignToPrimary) => {
  const {
    presenceOnly,
    size,
    textPosition
  } = state;
  const primaryTextBaseClassName = usePrimaryTextBaseClassName();
  const optionalTextBaseClassName = useOptionalTextBaseClassName();
  const textStyles = useTextStyles();
  let primaryTextSize;
  let alignToPrimaryClassName;
  if (presenceOnly) {
    if (size === 'extra-small') {
      primaryTextSize = state.numTextLines <= 1 && textStyles.caption1;
    } else if (size === 'extra-large' || size === 'huge') {
      primaryTextSize = textStyles.subtitle2;
    }
    if (alignToPrimary) {
      if (textPosition === 'before') {
        alignToPrimaryClassName = textStyles.beforeAlignToPrimary;
      } else if (textPosition === 'after') {
        alignToPrimaryClassName = textStyles.afterAlignToPrimary;
      }
    }
  } else {
    if (size === 'huge') {
      primaryTextSize = textStyles.subtitle2;
    } else if (size === 'extra-large') {
      primaryTextSize = textStyles.subtitle2;
    }
  }
  return {
    primaryTextClassName: mergeClasses(primaryTextBaseClassName, primaryTextSize, alignToPrimaryClassName),
    optionalTextClassName: mergeClasses(optionalTextBaseClassName, !presenceOnly && size === 'huge' && textStyles.body1, alignToPrimaryClassName)
  };
};