'use client';
import * as React from 'react';
import { mergeClasses } from '@griffel/react';
import { applyTriggerPropsToChildren, getTriggerChild, getReactElementRef, useMergedRefs } from '@fluentui/react-utilities';
import { OverflowContext } from '../overflowContext';
import { updateVisibilityAttribute, useOverflowContainer } from '../useOverflowContainer';
import { useOverflowStyles } from './useOverflowStyles.styles';
/**
 * Provides an OverflowContext for OverflowItem descendants.
 */ export const Overflow = /*#__PURE__*/ React.forwardRef((props, ref)=>{
    const styles = useOverflowStyles();
    const { children, minimumVisible, overflowAxis = 'horizontal', overflowDirection, padding, onOverflowChange, hasHiddenItems } = props;
    const [overflowState, setOverflowState] = React.useState({
        hasOverflow: false,
        itemVisibility: {},
        groupVisibility: {}
    });
    // useOverflowContainer wraps this method in a useEventCallback.
    const update = (data)=>{
        const { visibleItems, invisibleItems, groupVisibility } = data;
        const itemVisibility = {};
        visibleItems.forEach((item)=>{
            itemVisibility[item.id] = true;
        });
        invisibleItems.forEach((x)=>itemVisibility[x.id] = false);
        const newState = {
            hasOverflow: data.invisibleItems.length > 0,
            itemVisibility,
            groupVisibility
        };
        onOverflowChange === null || onOverflowChange === void 0 ? void 0 : onOverflowChange(null, {
            ...newState
        });
        setOverflowState(newState);
    };
    const { containerRef, registerItem, updateOverflow, registerOverflowMenu, registerDivider } = useOverflowContainer(update, {
        overflowDirection,
        overflowAxis,
        padding,
        minimumVisible,
        hasHiddenItems,
        onUpdateItemVisibility: updateVisibilityAttribute
    });
    const child = getTriggerChild(children);
    const clonedChild = applyTriggerPropsToChildren(children, {
        ref: useMergedRefs(containerRef, ref, getReactElementRef(child)),
        className: mergeClasses('fui-Overflow', styles.overflowMenu, styles.overflowingItems, child === null || child === void 0 ? void 0 : child.props.className)
    });
    return /*#__PURE__*/ React.createElement(OverflowContext.Provider, {
        value: {
            itemVisibility: overflowState.itemVisibility,
            groupVisibility: overflowState.groupVisibility,
            hasOverflow: overflowState.hasOverflow,
            registerItem,
            updateOverflow,
            registerOverflowMenu,
            registerDivider
        }
    }, clonedChild);
});
